/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.fieldtypes;

import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityFieldData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public abstract class AbstractLocalIdentityField<T>
implements LocalIdentityField<T> {
    private final LocalIdentityFieldData data;
    private boolean markedForDelete = false;

    public AbstractLocalIdentityField() {
        this.data = null;
    }

    public AbstractLocalIdentityField(LocalIdentityFieldData data) {
        this.data = data;
    }

    @Override
    public LocalIdentityFieldData getData() {
        return this.data;
    }

    @Override
    public Map<String, Boolean> getAttributes() {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        this.getConfig().getAttributes().forEach(attr -> attributes.put((String)attr, false));
        this.getData().getEnabledAttributes().forEach(enabledAttr -> attributes.put((String)enabledAttr, true));
        return attributes;
    }

    @Override
    public List<ValidatorException> validateDefaultValue(String defaultValue, List<String> options) {
        return Collections.emptyList();
    }

    @Override
    public List<ValidatorException> validateOptions(List<String> options) {
        return Collections.emptyList();
    }

    @Override
    public List<ValidatorException> validatePages(boolean profilePageField, boolean registrationPageField) {
        if (!profilePageField && !registrationPageField) {
            ValidatorException exception = new ValidatorException("This field must be enabled to show on at least one page.", ValidationConstraint.REQUIRED);
            return Collections.singletonList(exception);
        }
        return Collections.emptyList();
    }

    @Override
    public List<ValidatorException> validateAttributes() {
        if (this.isRequired() && this.isReadOnly()) {
            ValidatorException exception = new ValidatorException("Fields cannot be marked as Read-Only and Required. Please select only one to continue.", ValidationConstraint.REQUIRED);
            return Collections.singletonList(exception);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean compareData(String[] requestData, String[] fieldData) {
        if (this.isMultiValue()) {
            ArrayList requestDataList = requestData != null ? Arrays.asList(requestData) : new ArrayList();
            ArrayList fieldDataList = fieldData != null ? Arrays.asList(fieldData) : new ArrayList();
            return requestDataList.size() == fieldDataList.size() && requestDataList.containsAll(fieldDataList);
        }
        String requestDataString = requestData == null ? "" : requestData[0];
        String fieldDataString = fieldData == null ? "" : fieldData[0];
        return requestDataString.equals(fieldDataString);
    }

    @Override
    public boolean isMarkedForDelete() {
        return this.markedForDelete;
    }

    @Override
    public void setMarkedForDelete(boolean markedForDelete) {
        this.markedForDelete = markedForDelete;
    }
}

