/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.fieldtypes;

import com.pingidentity.localidentity.fieldtypes.AbstractLocalIdentityField;
import com.pingidentity.localidentity.fieldtypes.AbstractLocalIdentityFieldConfig;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityFieldData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;
import org.sourceid.localidentity.data.BooleanFieldData;
import org.sourceid.localidentity.data.FieldData;

public class CheckboxField
extends AbstractLocalIdentityField<Boolean> {
    private static final CheckboxFieldConfig CONFIG = new CheckboxFieldConfig();
    private static final List<String> TRUE_BOOLEAN_VALUES = new ArrayList<String>(){
        {
            this.add("true");
            this.add("TRUE");
            this.add("True");
            this.add("on");
            this.add("On");
            this.add("ON");
        }
    };
    public static final String NAME = "Checkbox";
    public static final String MUST_BE_CHECKED = "Must Be Checked";

    public CheckboxField() {
    }

    @Override
    public boolean isRequired() {
        return this.getData().getEnabledAttributes().contains(MUST_BE_CHECKED);
    }

    public CheckboxField(LocalIdentityFieldData data) {
        super(data);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public AbstractLocalIdentityFieldConfig getConfig() {
        return CONFIG;
    }

    @Override
    public LocalIdentityField newInstance(LocalIdentityFieldData data) {
        return new CheckboxField(data);
    }

    @Override
    public FieldData<Boolean> getFieldData(String[] values) {
        Boolean[] results;
        if (values != null) {
            results = new Boolean[1];
            results[0] = StringUtils.isNotBlank((String)values[0]) ? Boolean.valueOf(TRUE_BOOLEAN_VALUES.contains(values[0])) : null;
        } else {
            results = null;
        }
        return new BooleanFieldData(this.getData().getId(), false, results);
    }

    @Override
    public boolean compareData(String[] requestData, String[] fieldData) {
        String requestDataString = requestData == null ? "FALSE" : requestData[0];
        String fieldDataString = fieldData == null ? "FALSE" : fieldData[0];
        boolean requestDataValue = TRUE_BOOLEAN_VALUES.contains(requestDataString);
        boolean fieldDataValue = TRUE_BOOLEAN_VALUES.contains(fieldDataString);
        return requestDataValue == fieldDataValue;
    }

    @Override
    public List<ValidatorException> validateDefaultValue(String defaultValue, List<String> options) {
        if (!defaultValue.equalsIgnoreCase(Boolean.TRUE.toString()) && !defaultValue.equalsIgnoreCase(Boolean.FALSE.toString())) {
            ValidatorException exception = new ValidatorException("Checkbox default values can only be set to 'true' or 'false'.", ValidationConstraint.REQUIRED);
            return Collections.singletonList(exception);
        }
        return Collections.emptyList();
    }

    @Override
    public List<ValidatorException> validateAttributes() {
        if (this.isRequired() && this.isReadOnly()) {
            ValidatorException exception = new ValidatorException("A Checkbox field cannot be marked as Read-Only and Must Be Checked. Please select only one to continue.", ValidationConstraint.REQUIRED);
            return Collections.singletonList(exception);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isValidRequiredValue(Object value) {
        return this.isCheckedValue(value);
    }

    public boolean isCheckedValue(Object value) {
        if (super.isValidRequiredValue(value)) {
            if (value instanceof String && TRUE_BOOLEAN_VALUES.contains(value)) {
                return true;
            }
            if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    public static class CheckboxFieldConfig
    extends AbstractLocalIdentityFieldConfig {
        @Override
        public List<String> getAttributes() {
            return Collections.unmodifiableList(Arrays.asList(CheckboxField.MUST_BE_CHECKED, "Mask Log Values", "Read-Only"));
        }

        @Override
        public boolean isShowDefaultValueField() {
            return true;
        }

        @Override
        public boolean isShowOptionsField() {
            return false;
        }
    }
}

