/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.fieldtypes;

import com.pingidentity.localidentity.fieldtypes.AbstractLocalIdentityField;
import com.pingidentity.localidentity.fieldtypes.AbstractLocalIdentityFieldConfig;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityFieldData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;
import org.sourceid.localidentity.data.FieldData;
import org.sourceid.localidentity.data.StringFieldData;

public class CheckboxGroupField
extends AbstractLocalIdentityField<String> {
    private static final CheckboxGroupFieldConfig CONFIG = new CheckboxGroupFieldConfig();
    public static final String NAME = "Checkbox Group";
    public static final String MUST_PICK_ONE = "Must Pick One";

    public CheckboxGroupField() {
    }

    public CheckboxGroupField(LocalIdentityFieldData data) {
        super(data);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public AbstractLocalIdentityFieldConfig getConfig() {
        return CONFIG;
    }

    @Override
    public boolean isMultiValue() {
        return true;
    }

    @Override
    public boolean isRequired() {
        return this.getData().getEnabledAttributes().contains(MUST_PICK_ONE);
    }

    @Override
    public List<ValidatorException> validateOptions(List<String> options) {
        if (options.size() < 2) {
            ValidatorException exception = new ValidatorException("There must be at least two options defined for the Checkbox Group type.", ValidationConstraint.REQUIRED);
            return Collections.singletonList(exception);
        }
        return super.validateOptions(options);
    }

    @Override
    public LocalIdentityField newInstance(LocalIdentityFieldData data) {
        return new CheckboxGroupField(data);
    }

    @Override
    public List<ValidatorException> validateAttributes() {
        if (this.isRequired() && this.isReadOnly()) {
            ValidatorException exception = new ValidatorException("A Checkbox Group field cannot be marked as Read-Only and Must Pick One. Please select only one to continue.", ValidationConstraint.REQUIRED);
            return Collections.singletonList(exception);
        }
        return Collections.emptyList();
    }

    @Override
    public FieldData<String> getFieldData(String[] values) {
        return new StringFieldData(this.getData().getId(), this.isMultiValue(), values);
    }

    public static class CheckboxGroupFieldConfig
    extends AbstractLocalIdentityFieldConfig {
        @Override
        public List<String> getAttributes() {
            return Collections.unmodifiableList(Arrays.asList(CheckboxGroupField.MUST_PICK_ONE, "Mask Log Values", "Read-Only"));
        }

        @Override
        public boolean isShowDefaultValueField() {
            return false;
        }

        @Override
        public boolean isShowOptionsField() {
            return true;
        }
    }
}

