/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.fieldtypes;

import com.pingidentity.localidentity.errors.LocalIdentityFieldsError;
import com.pingidentity.localidentity.fieldtypes.CheckboxField;
import com.pingidentity.localidentity.fieldtypes.CheckboxGroupField;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.sdk.api.authn.model.action.RegisterUser;
import com.pingidentity.sdk.api.authn.util.ParamMapping;
import com.pingidentity.util.LocaleUtilWrapper;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class RequiredFieldValidator {
    private final HttpServletRequest req;
    private final LocaleUtilWrapper localeUtil;
    private LocalIdentityFieldsError errors;
    private final List<LocalIdentityField<?>> requiredFields;

    public RequiredFieldValidator(HttpServletRequest req, List<LocalIdentityField<?>> requiredFields) {
        this(req, requiredFields, new LocaleUtilWrapper());
    }

    public RequiredFieldValidator(HttpServletRequest req, List<LocalIdentityField<?>> requiredFields, LocaleUtilWrapper localeUtil) {
        this.req = req;
        this.requiredFields = requiredFields;
        this.localeUtil = localeUtil;
    }

    public void validate() {
        this.errors = new LocalIdentityFieldsError();
        this.requiredFields.forEach(field -> {
            ParamMapping fieldMapping = new ParamMapping(field.getData().getId(), RegisterUser.class, model -> model.getFieldValues().get(field.getData().getId()), model -> model);
            Object value = fieldMapping.getValue(this.req);
            if (!field.isValidRequiredValue(value)) {
                String userMessage = this.localeUtil.getLocalizedString(this.req, "pingfederate-messages", this.getMessageKey((LocalIdentityField<?>)field), new String[]{field.getData().getLabel()});
                this.errors.addErrorDetail(new LocalIdentityFieldsError.LocalIdentityFieldError.Builder().setField((LocalIdentityField<?>)field).setUserMessageKey(this.getMessageKey((LocalIdentityField<?>)field)).setUserMessage(userMessage).setCode("FIELD_REQUIRED").build());
            }
        });
    }

    public LocalIdentityFieldsError getErrors() {
        return this.errors;
    }

    public boolean isValid() {
        if (this.errors == null) {
            throw new RuntimeException("Validate has not been called yet.");
        }
        return this.errors.getErrorDetails().isEmpty();
    }

    private String getMessageKey(LocalIdentityField<?> field) {
        if (field instanceof CheckboxField) {
            return "local.identity.required.checkbox.not.selected";
        }
        if (field instanceof CheckboxGroupField) {
            return "local.identity.nothing.selected.for.checkboxgroup";
        }
        return "local.identity.field.required";
    }
}

