/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.log4j.appender;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseAppender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;

@Plugin(name="PingFailover", category="Core", elementType="appender", printObject=true)
public final class PingFailoverAppender
extends AbstractAppender {
    private static final int DEFAULT_INTERVAL_SECONDS = 60;
    private static final int DEFAULT_WRITE_TIMEOUT_MILLI = 0;
    private static final int DEFAULT_THREAD_COUNT = 20;
    private final String primaryRef;
    private final String[] failovers;
    private final Configuration config;
    private AppenderControl primary;
    private final long intervalMillis;
    private final int writeTimeoutMillis;
    private final ExecutorService executor;
    private final List<AppenderControl> failoverAppenders = new ArrayList<AppenderControl>();
    private AtomicReference<PrimaryState> primaryState = new AtomicReference<PrimaryState>(new PrimaryState(AppenderState.ACTIVE, 0L));

    private PingFailoverAppender(String name, Filter filter, String primary, String[] failovers, int intervalMillis, int writeTimeoutMillis, int threadCount, Configuration config, boolean ignoreExceptions) {
        super(name, filter, null, ignoreExceptions, Property.EMPTY_ARRAY);
        this.primaryRef = primary;
        this.failovers = failovers;
        this.config = config;
        this.intervalMillis = intervalMillis;
        this.writeTimeoutMillis = writeTimeoutMillis;
        this.executor = new ThreadPoolExecutor(0, threadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public void start() {
        Map map = this.config.getAppenders();
        int errors = 0;
        if (map.containsKey(this.primaryRef)) {
            this.primary = new AppenderControl((Appender)map.get(this.primaryRef), null, null);
        } else {
            LOGGER.error("Unable to locate primary Appender " + this.primaryRef);
            ++errors;
        }
        for (String name : this.failovers) {
            if (map.containsKey(name)) {
                this.failoverAppenders.add(new AppenderControl((Appender)map.get(name), null, null));
                continue;
            }
            LOGGER.error("Failover appender " + name + " is not configured");
        }
        if (this.failoverAppenders.isEmpty()) {
            LOGGER.error("No failover appenders are available");
            ++errors;
        }
        if (errors == 0) {
            super.start();
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        super.stop(timeout, timeUnit);
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(timeout, timeUnit)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
        this.primary.stop(timeout, timeUnit);
        this.failoverAppenders.forEach(appender -> appender.stop(timeout, timeUnit));
        return true;
    }

    public void append(LogEvent event) {
        if (!this.isStarted()) {
            this.error("PingFailoverAppender " + this.getName() + " did not start successfully");
            return;
        }
        AppenderState appenderState = this.getPrimaryAppenderState();
        switch (appenderState) {
            default: {
                this.callAppender(event);
                break;
            }
            case FAILED: {
                this.failover(event, null);
            }
            case SHUTDOWN: 
        }
    }

    private void callAppender(LogEvent event) {
        Runnable runnable = () -> {
            this.primary.callAppender(event);
            if (this.primaryState.get().state == AppenderState.RETRY || this.primaryState.get().state == AppenderState.ACTIVE) {
                this.primaryState.set(new PrimaryState(AppenderState.ACTIVE, 0L));
            }
        };
        try {
            this.validatePrimaryAppender(this.primary.getAppender());
            if (this.writeTimeoutMillis > 0) {
                Future<?> submit = this.executor.submit(runnable);
                submit.get(this.writeTimeoutMillis, TimeUnit.MILLISECONDS);
            } else {
                runnable.run();
            }
        }
        catch (Exception ex) {
            this.primaryState.set(new PrimaryState(AppenderState.FAILED, System.currentTimeMillis() + this.intervalMillis));
            this.failover(event, ex);
        }
    }

    private void validatePrimaryAppender(Appender primary) throws AppenderLoggingException {
        AbstractDatabaseAppender dbAppender;
        if (primary instanceof AbstractDatabaseAppender && ((dbAppender = (AbstractDatabaseAppender)primary).getManager() == null || !dbAppender.getManager().isRunning())) {
            String unformattedMsg = "%s JDBC appender is not initialized. Ensure that database configuration is correct and database-driver JAR file is installed.";
            String msg = String.format(unformattedMsg, primary.getName());
            LOGGER.error(msg);
            throw new AppenderLoggingException(msg);
        }
    }

    private void failover(LogEvent event, Exception ex) {
        LoggingException re = ex != null ? (ex instanceof LoggingException ? (LoggingException)ex : new LoggingException((Throwable)ex)) : null;
        boolean written = false;
        Exception failoverException = null;
        for (AppenderControl control : this.failoverAppenders) {
            try {
                LogEvent failoverEvent;
                Appender writeToAppender;
                control.callAppender(event);
                written = true;
                if (re == null) break;
                String appenderName = control.getAppender().getName();
                if (appenderName.contains("Audit") || appenderName.contains("Provisioner")) {
                    LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
                    Configuration config = ctx.getConfiguration();
                    writeToAppender = config.getAppender("CONSOLE-ERROR");
                    failoverEvent = this.createFailoverEvent(this.primary, control, null);
                } else {
                    writeToAppender = control.getAppender();
                    failoverEvent = this.createFailoverEvent(this.primary, control, (Throwable)re);
                }
                writeToAppender.append(failoverEvent);
                break;
            }
            catch (Exception fex) {
                if (failoverException != null) continue;
                failoverException = fex;
            }
        }
        if (!written && !this.ignoreExceptions()) {
            if (re != null) {
                throw re;
            }
            throw new LoggingException("Unable to write to failover appenders", (Throwable)failoverException);
        }
    }

    private LogEvent createFailoverEvent(AppenderControl primary, AppenderControl failover, Throwable exception) {
        String message = "The primary appender (" + primary.getAppender().getName() + ") failed. Switching over to backup appender (" + failover.getAppender().getName() + ")";
        SimpleMessage msg = new SimpleMessage(message);
        return Log4jLogEvent.newBuilder().setLevel(Level.ERROR).setMessage((Message)msg).setThrown(exception).setLoggerName(PingFailoverAppender.class.getName()).build();
    }

    private AppenderState getPrimaryAppenderState() {
        long localCheckMillis = this.primaryState.get().nextCheckMillis;
        switch (this.primaryState.get().state) {
            case ACTIVE: {
                return AppenderState.ACTIVE;
            }
            case FAILED: {
                if (localCheckMillis != 0L && System.currentTimeMillis() > localCheckMillis) {
                    this.primaryState.set(new PrimaryState(AppenderState.RETRY, localCheckMillis));
                    return AppenderState.RETRY;
                }
                return AppenderState.FAILED;
            }
            case RETRY: {
                return AppenderState.FAILED;
            }
            case SHUTDOWN: {
                return AppenderState.SHUTDOWN;
            }
        }
        throw new IllegalStateException("default is not allowed");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(" primary=").append(this.primary).append(", failover={");
        boolean first = true;
        for (String str : this.failovers) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(str);
            first = false;
        }
        sb.append('}');
        return sb.toString();
    }

    @PluginFactory
    public static PingFailoverAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="primary") String primary, @PluginElement(value="Failovers") String[] failovers, @PluginAliases(value={"retryInterval"}) @PluginAttribute(value="retryIntervalSeconds") String retryIntervalSeconds, @PluginAttribute(value="writeTimeoutMillis") String writeTimeoutMillis, @PluginAttribute(value="threadCount") String threadCountStr, @PluginConfiguration Configuration config, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="ignoreExceptions") String ignore) {
        int retryIntervalMillis;
        if (name == null) {
            LOGGER.error("A name for the Appender must be specified");
            return null;
        }
        if (primary == null) {
            LOGGER.error("A primary Appender must be specified");
            return null;
        }
        if (failovers == null || failovers.length == 0) {
            LOGGER.error("At least one failover Appender must be specified");
            return null;
        }
        int seconds = PingFailoverAppender.parseInt((String)retryIntervalSeconds, (int)60);
        if (seconds >= 0) {
            retryIntervalMillis = seconds * 1000;
        } else {
            LOGGER.warn("Interval " + retryIntervalSeconds + " is less than zero. Using default");
            retryIntervalMillis = 60000;
        }
        int writeTimeoutInMillis = PingFailoverAppender.parseInt((String)writeTimeoutMillis, (int)0);
        int threadCount = PingFailoverAppender.parseInt((String)threadCountStr, (int)20);
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)true);
        return new PingFailoverAppender(name, filter, primary, failovers, retryIntervalMillis, writeTimeoutInMillis, threadCount, config, ignoreExceptions);
    }

    private static enum AppenderState {
        ACTIVE,
        RETRY,
        FAILED,
        SHUTDOWN;

    }

    private static final class PrimaryState {
        final AppenderState state;
        final long nextCheckMillis;

        private PrimaryState(AppenderState state, long nextCheckMillis) {
            this.state = state;
            this.nextCheckMillis = nextCheckMillis;
        }
    }
}

