/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.log4j.layout;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.net.Facility;
import org.apache.logging.log4j.core.net.Priority;
import org.apache.logging.log4j.core.util.NetUtils;

@Plugin(name="PingSyslogLayout", category="Core", elementType="layout", printObject=true)
public final class PingSyslogLayout
extends AbstractStringLayout {
    private static final long serialVersionUID = 1L;
    public static final Pattern NEWLINE_PATTERN = Pattern.compile("\\r?\\n");
    private final Facility facility;
    private final boolean includeNewLine;
    private final String escapeNewLine;
    private final Layout<? extends Serializable> layout;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss ", Locale.ENGLISH);
    private final String localHostname = NetUtils.getLocalHostname();

    protected PingSyslogLayout(Facility facility, boolean includeNL, String escapeNL, Charset charset, Layout<? extends Serializable> layout) {
        super(charset);
        this.facility = facility;
        this.includeNewLine = includeNL;
        this.escapeNewLine = escapeNL == null ? null : Matcher.quoteReplacement(escapeNL);
        this.layout = layout;
    }

    public String toSerializable(LogEvent event) {
        StringBuilder buf = new StringBuilder();
        buf.append('<');
        buf.append(Priority.getPriority((Facility)this.facility, (Level)event.getLevel()));
        buf.append('>');
        this.addDate(event.getTimeMillis(), buf);
        buf.append(' ');
        buf.append(this.localHostname);
        buf.append(' ');
        String message = (String)((Object)this.layout.toSerializable(event));
        if (null != this.escapeNewLine) {
            message = NEWLINE_PATTERN.matcher(message).replaceAll(this.escapeNewLine);
        }
        buf.append(message);
        if (this.includeNewLine) {
            buf.append('\n');
        }
        return buf.toString();
    }

    private synchronized void addDate(long timestamp, StringBuilder buf) {
        int index = buf.length() + 4;
        buf.append(this.dateFormat.format(new Date(timestamp)));
        if (buf.charAt(index) == '0') {
            buf.setCharAt(index, ' ');
        }
    }

    public Map<String, String> getContentFormat() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("structured", "false");
        result.put("formatType", "logfilepatternreceiver");
        result.put("dateFormat", this.dateFormat.toPattern());
        result.put("format", "<LEVEL>TIMESTAMP PROP(HOSTNAME) MESSAGE");
        return result;
    }

    @PluginFactory
    public static PingSyslogLayout createLayout(@PluginAttribute(value="facility", defaultString="LOCAL0") Facility facility, @PluginAttribute(value="newLine", defaultBoolean=false) boolean includeNewLine, @PluginAttribute(value="newLineEscape") String escapeNL, @PluginAttribute(value="charset", defaultString="UTF-8") Charset charset, @PluginElement(value="Layout") Layout<? extends Serializable> layout) {
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new PingSyslogLayout(facility, includeNewLine, escapeNL, charset, (Layout<? extends Serializable>)layout);
    }
}

