/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.log4j.pattern;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;

@Plugin(name="escape", category="Converter")
@ConverterKeys(value={"escape"})
public final class EscapePatternConverter
extends LogEventPatternConverter {
    public static final String NAME = "escape";
    private final List<PatternFormatter> formatters;
    private Platform platform;

    private EscapePatternConverter(Platform platform, List<PatternFormatter> formatters) {
        super(NAME, NAME);
        this.platform = platform;
        this.formatters = formatters;
    }

    public static EscapePatternConverter newInstance(Configuration config, String[] options) {
        if (options.length != 2) {
            LOGGER.error("Incorrect number of options on escape. Expected 2, received " + options.length);
            return null;
        }
        try {
            Platform.valueOf(options[0]);
        }
        catch (Exception e) {
            LOGGER.error("Invalid target platform supplied - valid platforms are " + Arrays.toString((Object[])Platform.values()));
            return null;
        }
        if (options[1] == null) {
            LOGGER.error("No pattern supplied on escape");
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser((Configuration)config);
        List formatters = parser.parse(options[1]);
        return new EscapePatternConverter(Platform.valueOf(options[0]), formatters);
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        LogEvent formattedLogEvent = this.platform.getFormatter().getFormattedLogEvent(event);
        for (PatternFormatter formatter : this.formatters) {
            formatter.format(formattedLogEvent, toAppendTo);
        }
    }

    public static class MySQLFormatter
    extends DBFormatter {
        @Override
        public String escapeBackslash(String value) {
            return StringUtils.replace((String)value, (String)"\\", (String)"\\\\");
        }
    }

    public static class DBFormatter
    extends Formatter {
        private static final String LINE_SEPERATOR = System.getProperty("line.separator");

        @Override
        protected LogEvent getFormattedLogEvent(LogEvent loggingEvent) {
            if (loggingEvent.getThrown() != null) {
                StackTraceElement[] stackTrace;
                StringBuffer logMessageSB = new StringBuffer();
                logMessageSB.append(loggingEvent.getMessage().getFormattedMessage());
                logMessageSB.append(LINE_SEPERATOR);
                for (StackTraceElement stackLine : stackTrace = loggingEvent.getThrown().getStackTrace()) {
                    logMessageSB.append(stackLine.toString());
                    logMessageSB.append(LINE_SEPERATOR);
                }
                return new Log4jLogEvent(loggingEvent.getLoggerName(), loggingEvent.getMarker(), loggingEvent.getLoggerFqcn(), loggingEvent.getLevel(), (Message)new SimpleMessage(logMessageSB.toString()), loggingEvent.getThrown(), loggingEvent.getContextMap(), loggingEvent.getContextStack(), loggingEvent.getThreadName(), loggingEvent.getSource(), loggingEvent.getTimeMillis());
            }
            return loggingEvent;
        }

        @Override
        public String escape(String value) {
            String escapedBackslashes = this.escapeBackslash(value);
            String finalValue = this.escapeSingleQuotes(escapedBackslashes);
            return finalValue;
        }

        public String escapeSingleQuotes(String value) {
            return StringUtils.replace((String)value, (String)"'", (String)"''");
        }

        public String escapeBackslash(String value) {
            return value;
        }

        @Override
        public boolean escapeProperties() {
            return true;
        }

        @Override
        public boolean escapeMessage() {
            return true;
        }
    }

    public static class CEFFormatter
    extends Formatter {
        @Override
        public String escape(String value) {
            String escapedBackslashes = this.escapeBackslash(value);
            String finalValue = this.escapeEqualSigns(escapedBackslashes);
            return finalValue;
        }

        public String escapeEqualSigns(String value) {
            return StringUtils.replace((String)value, (String)"=", (String)"\\=");
        }

        public String escapeBackslash(String value) {
            return StringUtils.replace((String)value, (String)"\\", (String)"\\\\");
        }

        @Override
        public boolean escapeProperties() {
            return true;
        }

        @Override
        public boolean escapeMessage() {
            return false;
        }
    }

    private static abstract class Formatter {
        private Formatter() {
        }

        protected LogEvent getFormattedLogEvent(LogEvent loggingEvent) {
            HashMap<String, String> loggingEventProperties = new HashMap<String, String>(loggingEvent.getContextMap());
            if (this.escapeProperties()) {
                for (String mdcKeyString : loggingEventProperties.keySet()) {
                    String valObj = (String)loggingEventProperties.get(mdcKeyString);
                    Object value = "";
                    if (valObj == null || !StringUtils.isNotEmpty((String)(value = (String)value + valObj))) continue;
                    String escapedValue = this.escape((String)value);
                    loggingEventProperties.put(mdcKeyString, escapedValue);
                }
            }
            String loggingMessage = loggingEvent.getMessage().getFormattedMessage();
            if (this.escapeMessage()) {
                String escapedMessage;
                loggingMessage = escapedMessage = this.escape(loggingMessage);
            }
            Log4jLogEvent loggingEventWithEscapes = new Log4jLogEvent(loggingEvent.getLoggerName(), loggingEvent.getMarker(), loggingEvent.getLoggerFqcn(), loggingEvent.getLevel(), (Message)new SimpleMessage(loggingMessage), loggingEvent.getThrown(), loggingEventProperties, loggingEvent.getContextStack(), loggingEvent.getThreadName(), loggingEvent.getSource(), loggingEvent.getTimeMillis());
            return loggingEventWithEscapes;
        }

        public abstract String escape(String var1);

        public abstract boolean escapeProperties();

        public abstract boolean escapeMessage();
    }

    private static enum Platform {
        CEF(new CEFFormatter()),
        DB(new DBFormatter()),
        MYSQL(new MySQLFormatter());

        private Formatter formatter;

        private Platform(Formatter escapeFormatter) {
            this.formatter = escapeFormatter;
        }

        public Formatter getFormatter() {
            return this.formatter;
        }
    }
}

