/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.log4j.pattern;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.sourceid.util.log.internal.HttpRequestLoggingUtil;

@Plugin(name="header", category="Converter")
@ConverterKeys(value={"header"})
public class HttpHeaderPatternConverter
extends LogEventPatternConverter {
    public static final String NAME = "header";
    private final String headerName;

    private HttpHeaderPatternConverter(String headerName) {
        super(NAME, NAME);
        this.headerName = headerName;
    }

    public static HttpHeaderPatternConverter newInstance(Configuration config, String[] options) {
        switch (options.length) {
            case 1: {
                return new HttpHeaderPatternConverter(options[0]);
            }
        }
        LOGGER.error("Incorrect number of options on 'header'. Expected 1, received " + options.length);
        return null;
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        String headerValue = HttpRequestLoggingUtil.getHttpHeaderValue(this.headerName);
        if (headerValue != null) {
            toAppendTo.append(headerValue);
        }
    }
}

