/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.log4j.pattern;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.sourceid.util.log.internal.HttpRequestLoggingUtil;

@Plugin(name="parameter", category="Converter")
@ConverterKeys(value={"parameter"})
public class HttpParameterPatternConverter
extends LogEventPatternConverter {
    public static final String NAME = "parameter";
    private final String parameter;

    private HttpParameterPatternConverter(String parameterName) {
        super(NAME, NAME);
        this.parameter = parameterName;
    }

    public static HttpParameterPatternConverter newInstance(Configuration config, String[] options) {
        switch (options.length) {
            case 1: {
                return new HttpParameterPatternConverter(options[0]);
            }
        }
        LOGGER.error("Incorrect number of options on 'parameter'. Expected 1, received " + options.length);
        return null;
    }

    public void format(LogEvent event, StringBuilder appendTo) {
        String paramValue = HttpRequestLoggingUtil.getHttpParameterValue(this.parameter);
        if (paramValue != null) {
            appendTo.append(paramValue);
        }
    }
}

