/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.log4j.pattern;

import com.pingidentity.localidentity.TrackedParamsAuditLogger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;

@Plugin(name="trackedparameter", category="Converter")
@ConverterKeys(value={"trackedparameter"})
public class TrackedParamPatternConverter
extends LogEventPatternConverter {
    public static final String NAME = "trackedparameter";
    private final String parameter;

    private TrackedParamPatternConverter(String parameterName) {
        super(NAME, NAME);
        this.parameter = parameterName;
    }

    public static TrackedParamPatternConverter newInstance(Configuration config, String[] options) {
        switch (options.length) {
            case 1: {
                return new TrackedParamPatternConverter(options[0]);
            }
        }
        LOGGER.error("Incorrect number of options on 'trackedparameter'. Expected 1, received " + options.length);
        return null;
    }

    public void format(LogEvent event, StringBuilder appendTo) {
        String paramValue = TrackedParamsAuditLogger.getTrackedParam(this.parameter);
        if (paramValue != null) {
            appendTo.append(paramValue);
        }
    }
}

