/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.monitoring;

import com.pingidentity.monitoring.MonitoringService;
import com.pingidentity.monitoring.ThreadPoolExhaustionOperator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ThreadPoolExhaustionConfig {
    private static final Log log = LogFactory.getLog(ThreadPoolExhaustionConfig.class);
    public static final String MBEAN_NAME = "MBeanName";
    public static final String MBEAN_ATTRIBUTE = "MBeanAttribute";
    public static final String OPERATOR = "Operator";
    public static final String THRESHOLD = "Threshold";
    public static final String SAMPLE_INTERVAL_SECONDS = "SampleIntervalSeconds";
    public static final String SAMPLES = "Samples";
    public static final String QUIET_PERIOD_MINUTES = "QuietPeriodMinutes";
    private final MonitoringService monitoringService = MgmtFactory.getMonitoringService();
    private String mBeanName;
    private String mBeanAttribute;
    private ThreadPoolExhaustionOperator operator;
    private double threshold;
    private long sampleIntervalSeconds;
    private int samples;
    private long quietPeriodMinutes;
    private boolean validConfig;

    public ThreadPoolExhaustionConfig(Map<String, String> threadPoolExhaustionConfigMap) {
        if (this.validate(threadPoolExhaustionConfigMap)) {
            this.mBeanName = threadPoolExhaustionConfigMap.getOrDefault(MBEAN_NAME, "org.eclipse.jetty.util.thread:type=queuedthreadpool,id=0");
            this.mBeanAttribute = threadPoolExhaustionConfigMap.getOrDefault(MBEAN_ATTRIBUTE, "queueSize");
            this.operator = ThreadPoolExhaustionOperator.fromOperatorName(threadPoolExhaustionConfigMap.getOrDefault(OPERATOR, "GreaterThan"));
            this.threshold = Double.parseDouble(threadPoolExhaustionConfigMap.getOrDefault(THRESHOLD, "100"));
            this.sampleIntervalSeconds = Long.parseLong(threadPoolExhaustionConfigMap.getOrDefault(SAMPLE_INTERVAL_SECONDS, "15"));
            this.samples = Integer.parseInt(threadPoolExhaustionConfigMap.getOrDefault(SAMPLES, "2"));
            this.quietPeriodMinutes = Long.parseLong(threadPoolExhaustionConfigMap.getOrDefault(QUIET_PERIOD_MINUTES, "15"));
            this.validConfig = true;
        } else {
            this.validConfig = false;
        }
    }

    public String getMBeanName() {
        return this.mBeanName;
    }

    public void setMBeanName(String mBeanName) {
        this.mBeanName = mBeanName;
    }

    public String getMBeanAttribute() {
        return this.mBeanAttribute;
    }

    public void setMBeanAttribute(String mBeanAttribute) {
        this.mBeanAttribute = mBeanAttribute;
    }

    public ThreadPoolExhaustionOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ThreadPoolExhaustionOperator operator) {
        this.operator = operator;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public long getSampleIntervalSeconds() {
        return this.sampleIntervalSeconds;
    }

    public void setSampleIntervalSeconds(long sampleIntervalSeconds) {
        this.sampleIntervalSeconds = sampleIntervalSeconds;
    }

    public int getSamples() {
        return this.samples;
    }

    public void setSamples(int samples) {
        this.samples = samples;
    }

    public long getQuietPeriodMinutes() {
        return this.quietPeriodMinutes;
    }

    public void setQuietPeriodMinutes(long quietPeriodMinutes) {
        this.quietPeriodMinutes = quietPeriodMinutes;
    }

    public boolean isValidConfig() {
        return this.validConfig;
    }

    public void setValidConfig(boolean validConfig) {
        this.validConfig = validConfig;
    }

    private boolean validate(Map<String, String> threadPoolExhaustionConfigMap) {
        if (threadPoolExhaustionConfigMap.isEmpty()) {
            log.error((Object)"Configuration for Thread Pool Exhaustion Monitoring not found.");
            return false;
        }
        if (threadPoolExhaustionConfigMap.get(MBEAN_NAME) == null) {
            log.error((Object)"Configuration for Thread Pool Exhaustion Monitoring: MBeanName is not found.");
            return false;
        }
        if (threadPoolExhaustionConfigMap.get(MBEAN_ATTRIBUTE) == null) {
            log.error((Object)"Configuration for Thread Pool Exhaustion Monitoring: MBeanAttribute is not found.");
            return false;
        }
        if (threadPoolExhaustionConfigMap.get(OPERATOR) == null) {
            log.error((Object)"Configuration for Thread Pool Exhaustion Monitoring: Operator is not found.");
            return false;
        }
        if (!threadPoolExhaustionConfigMap.get(OPERATOR).equals(ThreadPoolExhaustionOperator.GREATER_THAN.getThreadPoolExhaustionOperatorName()) && !threadPoolExhaustionConfigMap.get(OPERATOR).equals(ThreadPoolExhaustionOperator.LESS_THAN.getThreadPoolExhaustionOperatorName())) {
            log.error((Object)("Comparison value for 'Operator' is not supported. Please use " + ThreadPoolExhaustionOperator.GREATER_THAN + " or " + ThreadPoolExhaustionOperator.LESS_THAN + "."));
            return false;
        }
        if (threadPoolExhaustionConfigMap.get(THRESHOLD) == null) {
            log.error((Object)"Configuration for Thread Pool Exhaustion Monitoring: Threshold is not found.");
            return false;
        }
        try {
            Double.parseDouble(threadPoolExhaustionConfigMap.get(THRESHOLD));
        }
        catch (NumberFormatException ex) {
            log.error((Object)"Unable to parse thread pool exhaustion configuration value for 'Threshold'.");
            return false;
        }
        if (threadPoolExhaustionConfigMap.get(SAMPLE_INTERVAL_SECONDS) == null) {
            log.error((Object)"Configuration for Thread Pool Exhaustion Monitoring: SampleIntervalSeconds is not found.");
            return false;
        }
        try {
            if (Long.parseLong(threadPoolExhaustionConfigMap.get(SAMPLE_INTERVAL_SECONDS)) < 1L) {
                log.error((Object)"The thread pool exhaustion configuration value for 'SampleIntervalSeconds' must be greater than or equal to 1.");
                return false;
            }
        }
        catch (NumberFormatException ex) {
            log.error((Object)"Unable to parse thread pool exhaustion configuration value for 'SampleIntervalSeconds'.");
            return false;
        }
        if (threadPoolExhaustionConfigMap.get(SAMPLES) == null) {
            log.error((Object)"Configuration for Thread Pool Exhaustion Monitoring: Samples is not found.");
            return false;
        }
        try {
            if (Integer.parseInt(threadPoolExhaustionConfigMap.get(SAMPLES)) < 1) {
                log.error((Object)"The thread pool exhaustion configuration value for 'Samples' must be greater than or equal to 1.");
                return false;
            }
        }
        catch (NumberFormatException ex) {
            log.error((Object)"Unable to parse thread pool exhaustion configuration value for 'Samples'.");
            return false;
        }
        if (threadPoolExhaustionConfigMap.get(QUIET_PERIOD_MINUTES) == null) {
            log.error((Object)"Configuration for Thread Pool Exhaustion Monitoring: QuietPeriodMinutes is not found.");
            return false;
        }
        try {
            if (Long.parseLong(threadPoolExhaustionConfigMap.get(QUIET_PERIOD_MINUTES)) < 0L) {
                log.error((Object)"The thread pool exhaustion configuration value for 'QuietPeriodMinutes' must be greater than or equal to 0.");
                return false;
            }
        }
        catch (NumberFormatException ex) {
            log.error((Object)"Unable to parse thread pool exhaustion configuration value for 'QuietPeriodMinutes'.");
            return false;
        }
        return true;
    }
}

