/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.monitoring.elements.impl;

import com.pingidentity.common.util.resiliency.BulkheadManager;
import com.pingidentity.pingcommons.monitoring.elements.MonitorElementBase;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class Bulkheads
extends MonitorElementBase {
    private final BulkheadManager bulkheadManager = MgmtFactory.getBulkheadManager();

    public Map<String, Object> getResults() {
        MeterRegistry bulkheadMeters = this.bulkheadManager.getBulkheadMeters();
        if (bulkheadMeters != null) {
            bulkheadMeters.find("available.concurrent.calls").gauges().forEach(gauge -> {
                String metric = String.format("bulkhead.%s.available.concurrent.calls", gauge.getId().getTag("bulkhead"));
                this.results.put(metric, Double.valueOf(gauge.value()).longValue());
            });
            bulkheadMeters.find("max.concurrent.calls").gauges().forEach(gauge -> {
                String metric = String.format("bulkhead.%s.max.concurrent.calls", gauge.getId().getTag("bulkhead"));
                this.results.put(metric, Double.valueOf(gauge.value()).longValue());
            });
            bulkheadMeters.find("exception.count").counters().forEach(counter -> {
                String metric = String.format("bulkhead.%s.error.count", counter.getId().getTag("bulkhead"));
                this.results.put(metric, Double.valueOf(counter.count()).longValue());
            });
        }
        return this.results;
    }
}

