/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.monitoring.elements.impl;

import com.pingidentity.monitoring.metrics.MeterManager;
import com.pingidentity.monitoring.metrics.MeterMapper;
import com.pingidentity.pingcommons.monitoring.elements.MonitorElementBase;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mode;
import org.sourceid.saml20.service.util.Node;

public class Cluster
extends MonitorElementBase {
    private static final String CLUSTER_MEMBERS_DETAIL = "cluster.members.detail";

    public Map<String, Object> getResults() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        List<Node> nodes = MgmtFactory.getNodeIndexRegistry().getNodes();
        result.put("cluster.members", nodes.stream().map(node -> node.getAddress().toString()).collect(Collectors.toList()));
        List nodeInfos = nodes.stream().map(this::toNodeInfo).collect(Collectors.toList());
        result.put(CLUSTER_MEMBERS_DETAIL, nodeInfos);
        MeterMapper responseTimeMapper = new MeterMapper("rpc", id -> String.format("cluster.rpc.%s", id.getTag("rpc.name")));
        MeterMapper errorsMapper = new MeterMapper("rpc.errors", id -> String.format("cluster.rpc.%s.errors", id.getTag("rpc.name")));
        result.putAll(MeterManager.getInstance().getStats(Arrays.asList(responseTimeMapper, errorsMapper)));
        return result;
    }

    private Map<String, Object> toNodeInfo(Node node) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("address", node.getAddress().toString());
        result.put("mode", node.getMode().name());
        if (node.getMode() == Mode.CLUSTERED_CONSOLE && node.getConsoleRole() != null) {
            result.put("consoleRole", node.getConsoleRole().name());
            if (node.getConsoleRoleLastUpdateDate() != null) {
                result.put("consoleRoleLastUpdated", node.getConsoleRoleLastUpdateDate());
            }
            if (node.getSynchronizationState() != null) {
                result.put("consoleConfigSyncStatus", (Object)node.getSynchronizationState().getConfigSyncStatus());
                Date syncTimeStamp = node.getSynchronizationState().getConfigSyncTimestamp();
                if (syncTimeStamp != null) {
                    result.put("consoleConfigSyncTimestamp", syncTimeStamp.toInstant());
                }
            }
        }
        return result;
    }
}

