/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.monitoring.elements.impl;

import com.pingidentity.monitoring.HeartbeatMBeanAttribute;
import com.pingidentity.pingcommons.monitoring.elements.MonitorElementBase;
import java.lang.management.ManagementFactory;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class MBeanAttributes
extends MonitorElementBase {
    private static final Log log = LogFactory.getLog(MBeanAttributes.class);

    public Map<String, Object> getResults() {
        List<HeartbeatMBeanAttribute> attributeInfos = MgmtFactory.getMonitoringService().getHeartbeatMBeanAttributes();
        this.results = new LinkedHashMap();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        for (HeartbeatMBeanAttribute attributeInfo : attributeInfos) {
            try {
                Object attributeValue = mBeanServer.getAttribute(new ObjectName(attributeInfo.getMBeanName()), attributeInfo.getAttributeName());
                this.results.put(attributeInfo.getTemplateKey(), attributeValue);
            }
            catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
                log.debug((Object)("Error occurred retrieving attribute, MBean=" + attributeInfo.getMBeanName() + ", attribute=" + attributeInfo.getAttributeName() + ": " + ExceptionUtil.toStringWithCauses(e)));
            }
        }
        return this.results;
    }
}

