/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.monitoring.jmx;

import com.pingidentity.monitoring.MonitoringService;
import com.pingidentity.monitoring.elements.impl.Adapters;
import com.pingidentity.monitoring.elements.impl.AuditLoggingMonitor;
import com.pingidentity.monitoring.elements.impl.Bulkheads;
import com.pingidentity.monitoring.elements.impl.Cluster;
import com.pingidentity.monitoring.elements.impl.Connections;
import com.pingidentity.monitoring.elements.impl.DataStores;
import com.pingidentity.monitoring.elements.impl.HttpRequests;
import com.pingidentity.monitoring.elements.impl.RuntimeStateMaps;
import com.pingidentity.monitoring.elements.impl.TransactionCounters;
import com.pingidentity.monitoring.metrics.MeterManager;
import com.pingidentity.pingcommons.monitoring.elements.MonitorElementBase;
import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;

public class MetricsMBean
implements DynamicMBean {
    private static final Log log = LogFactory.getLog(MetricsMBean.class);
    private final MonitorElementBase monitorElement;

    public static void registerMBeans() {
        MonitoringService monitoringService = MgmtFactory.getMonitoringService();
        Mediator mediator = MgmtFactory.getMediator();
        MetricsMBean.registerMBean(new DataStores(), "dataStores");
        if (mediator.isEngine()) {
            MetricsMBean.registerMBean(new HttpRequests(MeterManager.NodeContext.ENGINE), "httpRequests.engine");
            MetricsMBean.registerMBean(new RuntimeStateMaps(), "stateMaps");
            MetricsMBean.registerMBean(new TransactionCounters(), "transactions");
            if (monitoringService.isAdapterMetricsEnabled()) {
                MetricsMBean.registerMBean(new Adapters(), "adapters");
            }
            if (monitoringService.isConnectionMetricsEnabled()) {
                MetricsMBean.registerMBean(new Connections(), "connections");
            }
            if (monitoringService.isBulkheadMetricsEnabled()) {
                MetricsMBean.registerMBean(new Bulkheads(), "bulkheads");
            }
            if (monitoringService.isAuditLoggingMetricsEnabled()) {
                MetricsMBean.registerMBean(new AuditLoggingMonitor(), "auditLogging");
            }
        }
        if (mediator.isConsole()) {
            MetricsMBean.registerMBean(new HttpRequests(MeterManager.NodeContext.ADMIN), "httpRequests.admin");
        }
        if (mediator.isDistributable()) {
            MetricsMBean.registerMBean(new Cluster(), "cluster");
        }
    }

    private static void registerMBean(MonitorElementBase monitorElement, String mBeanName) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.registerMBean(new MetricsMBean(monitorElement), new ObjectName("pingfederate:name=" + mBeanName));
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            log.error((Object)("Unexpected error registering metrics MBean '" + mBeanName + "'"), (Throwable)e);
        }
    }

    private MetricsMBean(MonitorElementBase monitorElement) {
        this.monitorElement = monitorElement;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException("This MBean does not support attribute update");
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("This MBean does not support attribute update");
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        throw new UnsupportedOperationException("This MBean does not support any operations");
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Map<String, Object> metrics = this.getMetrics();
        Object attributeValue = metrics.get(attributeName);
        if (attributeValue == null) {
            throw new AttributeNotFoundException("Attribute '" + attributeName + "' not found");
        }
        return attributeValue;
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        AttributeList result = new AttributeList();
        Map<String, Object> metrics = this.getMetrics();
        for (String attributeName : attributeNames) {
            Object attributeValue = metrics.get(attributeName);
            if (attributeValue == null) continue;
            Attribute attribute = new Attribute(attributeName, attributeValue);
            result.add(attribute);
        }
        return result;
    }

    private Map<String, Object> getMetrics() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Map map = this.monitorElement.getResults();
            return map;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        Map<String, Object> metrics = this.getMetrics();
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[metrics.size()];
        int i = 0;
        for (Map.Entry<String, Object> metric : metrics.entrySet()) {
            String attributeName = metric.getKey();
            Object attributeValue = metric.getValue();
            attributes[i++] = new MBeanAttributeInfo(attributeName, attributeValue.getClass().getName(), attributeName, true, false, false);
        }
        MBeanInfo mBeanInfo = new MBeanInfo(this.getClass().getName(), "PingFederate metrics MBean", attributes, null, null, new MBeanNotificationInfo[0]);
        return mBeanInfo;
    }
}

