/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.monitoring.metrics;

import io.micrometer.core.instrument.Meter;
import java.util.function.Function;

public class MeterMapper {
    private final String meterId;
    private final Function<Meter.Id, String> nameMapper;
    private final Function<Meter.Id, String> countNameMapper;

    public MeterMapper(String meterId) {
        this(meterId, Meter.Id::getName);
    }

    public MeterMapper(String meterId, Function<Meter.Id, String> nameMapper) {
        this(meterId, nameMapper, null);
    }

    public MeterMapper(String meterId, Function<Meter.Id, String> nameMapper, Function<Meter.Id, String> countNameMapper) {
        this.meterId = meterId;
        this.nameMapper = nameMapper;
        this.countNameMapper = countNameMapper;
    }

    public String getMeterId() {
        return this.meterId;
    }

    public String getName(Meter.Id meterId) {
        return this.nameMapper.apply(meterId);
    }

    public String getCountName(Meter.Id meterId) {
        if (this.countNameMapper == null) {
            return this.getName(meterId) + ".count";
        }
        return this.countNameMapper.apply(meterId);
    }
}

