/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.monitoring.metrics.config;

import com.pingidentity.monitoring.MonitoringService;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class HeartbeatMeterFilter
implements MeterFilter {
    private final MonitoringService monitoringService = MgmtFactory.getMonitoringService();

    public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
        int histogramBufferLength = this.monitoringService.getHistogramBufferLength();
        return config.merge(DistributionStatisticConfig.builder().bufferLength(Integer.valueOf(histogramBufferLength)).percentiles(this.getPercentilesArray()).percentilePrecision(Integer.valueOf(this.monitoringService.getHistogramPercentilePrecision())).expiry(Duration.ofSeconds((long)histogramBufferLength * this.monitoringService.getStatisticsWindowSecs())).build());
    }

    public MeterFilterReply accept(Meter.Id id) {
        if (!this.monitoringService.isAdapterMetricsEnabled() && id.getName().startsWith("adapter.")) {
            return MeterFilterReply.DENY;
        }
        if (!this.monitoringService.isConnectionMetricsEnabled() && id.getName().startsWith("connection.")) {
            return MeterFilterReply.DENY;
        }
        if (!this.monitoringService.isBulkheadMetricsEnabled() && id.getName().startsWith("bulkhead")) {
            return MeterFilterReply.DENY;
        }
        if (!this.monitoringService.isAuditLoggingMetricsEnabled() && id.getName().startsWith("audit.logging")) {
            return MeterFilterReply.DENY;
        }
        return MeterFilterReply.NEUTRAL;
    }

    private double[] getPercentilesArray() {
        ArrayList<Double> listResult = new ArrayList<Double>();
        listResult.add(0.0);
        listResult.addAll(DoubleStream.of(this.monitoringService.getStatisticsPercentilesArray()).boxed().collect(Collectors.toList()));
        return listResult.stream().mapToDouble(Double::doubleValue).toArray();
    }
}

