/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingid;

import org.apache.commons.lang.StringUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class PingIdInitialSetupAdminService {
    private static final String PID_PROVISIONING_CONNECTION_STATE_NAME = "pid-connection-config";
    private static final String PID_PROVISIONING_CONNECTION_ID_NAME = "pid-connection-id";
    private static final String PID_PCV_ID_NAME = "pid-pcv-id";
    private final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private ConfigStore stateStore = ConfigStoreFarm.getConfig("pid-connection-config");

    public synchronized void saveProvisioningConnectionId(String connectionId) {
        this.stateStore.setStringValue(PID_PROVISIONING_CONNECTION_ID_NAME, connectionId);
    }

    public ConnectionBase getProvisioningConnection() {
        SpConnection provisioningConnection = null;
        try {
            String connectionId = this.stateStore.getStringValue(PID_PROVISIONING_CONNECTION_ID_NAME);
            if (StringUtils.isNotEmpty((String)connectionId)) {
                provisioningConnection = this.connectionManager.getSpConnectionBySystemId(connectionId);
            }
        }
        catch (NoSuchValueException ex) {
            return null;
        }
        return provisioningConnection;
    }

    public synchronized void savePcvId(String pcvId) {
        this.stateStore.setStringValue(PID_PCV_ID_NAME, pcvId);
    }

    public PasswordCredentialValidatorInstance getPCV() {
        PasswordCredentialValidatorInstance pcv = null;
        try {
            String id = this.stateStore.getStringValue(PID_PCV_ID_NAME);
            if (StringUtils.isNotEmpty((String)id)) {
                pcv = (PasswordCredentialValidatorInstance)MgmtFactory.getCredentialValidatorManager().getInstance(id);
            }
        }
        catch (NoSuchValueException ex) {
            return null;
        }
        return pcv;
    }
}

