/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.reencryption;

import com.pingidentity.reencryption.RegexUpdater;
import com.pingidentity.reencryption.Updater;
import java.io.File;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.xmlbeans.XmlCalendar;

public final class UpdaterFactory {
    private static final String CONNECTION_REGEX = "LastModified=\"[\\w\\\\.:-]*\"";
    private static final Pattern CONNECTION_PATTERN = Pattern.compile("LastModified=\"[\\w\\\\.:-]*\"");
    private static final String CLIENT_REGEX = "lastModified=\"[\\w\\\\.:-]*\"";
    private static final Pattern CLIENT_PATTERN = Pattern.compile("lastModified=\"[\\w\\\\.:-]*\"");

    private UpdaterFactory() {
        throw new UnsupportedOperationException("not allowed");
    }

    public static Updater getUpdaterForFile(File file) {
        if (file.getPath().contains(File.separator + "connections" + File.separator)) {
            return UpdaterFactory.newConnectionLastModifiedUpdater();
        }
        if (file.getPath().contains(File.separator + "oauth-clients" + File.separator)) {
            return UpdaterFactory.newClientLastModifiedUpdater();
        }
        return UpdaterFactory.noopUpdater();
    }

    private static Updater newConnectionLastModifiedUpdater() {
        String replacementString = String.format("LastModified=\"%s\"", new XmlCalendar(new Date()));
        return new RegexUpdater(CONNECTION_PATTERN, replacementString, RegexUpdater.ReplacementStrategy.ALL);
    }

    private static Updater newClientLastModifiedUpdater() {
        String replacementString = String.format("lastModified=\"%s\"", new XmlCalendar(new Date()));
        return new RegexUpdater(CLIENT_PATTERN, replacementString, RegexUpdater.ReplacementStrategy.FIRST);
    }

    private static Updater noopUpdater() {
        return content -> content;
    }
}

