/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.reencryption;

import com.pingidentity.reencryption.ReencryptUtils;
import com.pingidentity.reencryption.ReencryptionTarget;
import com.pingidentity.reencryption.Replacement;
import com.pingidentity.reencryption.ValueHandler;
import java.io.File;
import org.jose4j.jwk.JsonWebKeySet;

public class ValueReencryptor
implements ValueHandler {
    ReencryptionTarget target;
    JsonWebKeySet decryptionKeySet;

    @Override
    public void initialize(File f, JsonWebKeySet decryptionKeySet) {
        this.target = new ReencryptionTarget(f);
        this.decryptionKeySet = decryptionKeySet;
    }

    @Override
    public void initialize(String fileName, JsonWebKeySet decryptionKeySet) {
        this.target = new ReencryptionTarget(fileName);
        this.decryptionKeySet = decryptionKeySet;
    }

    @Override
    public void processValue(String value) {
        Replacement replacement = ReencryptUtils.processValue(value, this.decryptionKeySet);
        if (replacement != null) {
            if (replacement.isLegacyEncryptedField()) {
                this.target.setHasLegacyEncryptedField(true);
            } else {
                this.target.addToEncrypt(replacement);
            }
        }
    }

    @Override
    public Object getResult() {
        return this.target;
    }
}

