/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.reencryption.filescanner;

import com.pingidentity.reencryption.ReencryptUtils;
import com.pingidentity.reencryption.ValueHandler;
import com.pingidentity.reencryption.filescanner.FileScanner;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jose4j.jwk.JsonWebKeySet;

public class TextFileScanner
implements FileScanner {
    private static final Logger log = LogManager.getLogger(TextFileScanner.class);
    JsonWebKeySet decryptionKeySet;

    public TextFileScanner(JsonWebKeySet decryptionKeySet) {
        this.decryptionKeySet = decryptionKeySet;
    }

    @Override
    public Object scanFile(File file, ValueHandler valueHandler) {
        Object object;
        valueHandler.initialize(file, this.decryptionKeySet);
        String fileName = ReencryptUtils.getRelativeFilePath(file.getPath());
        FileInputStream inputStream = new FileInputStream(file);
        try {
            object = this.performScan(fileName, inputStream, valueHandler);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                String errorMessage = "Error parsing the file " + ReencryptUtils.getRelativeFilePath(file.getPath());
                log.error(errorMessage);
                log.debug(errorMessage, (Throwable)e);
                return valueHandler.getResult();
            }
        }
        ((InputStream)inputStream).close();
        return object;
    }

    @Override
    public Object scanData(String fileName, byte[] data, ValueHandler valueHandler) {
        valueHandler.initialize(fileName, this.decryptionKeySet);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            return this.performScan(fileName, inputStream, valueHandler);
        }
        catch (IOException e) {
            String errorMessage = "Error parsing the file " + fileName;
            log.error(errorMessage);
            log.debug("Error parsing the file " + fileName, (Throwable)e);
            return valueHandler.getResult();
        }
    }

    private Object performScan(String fileName, InputStream inputStream, ValueHandler valueHandler) throws IOException {
        String line;
        log.trace("Scanning text file " + fileName);
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = br.readLine()) != null) {
            valueHandler.processValue(line);
        }
        return valueHandler.getResult();
    }
}

