/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.reencryption.filescanner;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.reencryption.ReencryptUtils;
import com.pingidentity.reencryption.ValueHandler;
import com.pingidentity.reencryption.filescanner.FileScanner;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jose4j.jwk.JsonWebKeySet;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlFileScanner
implements FileScanner {
    private static final Logger log = LogManager.getLogger(XmlFileScanner.class);
    JsonWebKeySet decryptionKeySet;
    ErrorHandler emptyErrorHandler = new ErrorHandler(){

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    };

    public XmlFileScanner(JsonWebKeySet decryptionKeySet) {
        this.decryptionKeySet = decryptionKeySet;
    }

    @Override
    public Object scanData(String fileName, byte[] data, ValueHandler valueHandler) {
        valueHandler.initialize(fileName, this.decryptionKeySet);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            return this.performScan(fileName, inputStream, valueHandler);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            String errorMessage = "Error parsing the file " + fileName;
            log.error(errorMessage);
            log.debug(errorMessage, (Throwable)e);
            return valueHandler.getResult();
        }
    }

    @Override
    public Object scanFile(File file, ValueHandler valueHandler) {
        Object object;
        valueHandler.initialize(file, this.decryptionKeySet);
        String fileName = ReencryptUtils.getRelativeFilePath(file.getPath());
        FileInputStream inputStream = new FileInputStream(file);
        try {
            object = this.performScan(fileName, inputStream, valueHandler);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                String errorMessage = "Error parsing the file " + ReencryptUtils.getRelativeFilePath(file.getPath());
                log.error(errorMessage);
                log.debug(errorMessage, (Throwable)e);
                return valueHandler.getResult();
            }
        }
        ((InputStream)inputStream).close();
        return object;
    }

    private Object performScan(String fileName, InputStream inputStream, ValueHandler valueHandler) throws IOException, ParserConfigurationException, SAXException {
        log.trace("Scanning xml file " + fileName);
        DocumentBuilder db = XmlBeansUtil.getDocumentBuilder();
        db.setErrorHandler(this.emptyErrorHandler);
        Document doc = db.parse(inputStream);
        NodeList nodes = doc.getChildNodes();
        this.decryptNodes(nodes, valueHandler);
        return valueHandler.getResult();
    }

    public void decryptNodes(NodeList nodeList, ValueHandler valueHandler) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node currentNode = nodeList.item(i);
            this.decryptNode(currentNode, valueHandler);
            if (!currentNode.hasChildNodes()) continue;
            this.decryptNodes(currentNode.getChildNodes(), valueHandler);
        }
    }

    public void decryptNode(Node node, ValueHandler valueHandler) {
        if (node.getNodeType() == 3) {
            String value = node.getNodeValue();
            valueHandler.processValue(value);
        } else if (node.getNodeType() == 1) {
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node n = attributes.item(i);
                    this.decryptNode(n, valueHandler);
                }
            }
        } else if (node.getNodeType() == 2) {
            String value = node.getNodeValue();
            valueHandler.processValue(value);
        }
    }
}

