/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.resilience.action.impl;

import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.resilience.FailureThresholdAction;
import com.pingidentity.sdk.notification.NotificationEventType;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.saml20.domain.AuditLoggingSettings;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;

public class AuditLoggingFailureAction
implements FailureThresholdAction {
    private static final Logger logger = LoggerFactory.getLogger(AuditLoggingFailureAction.class);
    private final AuditLoggingSettings settings;
    private final String localAddress;
    private final int localNodeIndex;

    public AuditLoggingFailureAction(AuditLoggingSettings settings, String localAddress, int localNodeIndex) {
        this.localAddress = localAddress;
        this.localNodeIndex = localNodeIndex;
        this.settings = settings;
    }

    @Override
    public void thresholdExceeded(FailureThresholdAction.ThresholdInfo info) {
        logger.warn("Audit logging has reached the configured threshold and is considered to be in a failure state. Failure rate: {}%", (Object)this.formatFailureRate(info.getNumFailures()));
        this.publishNotification(info, NotificationEventType.AUDIT_LOGGING_FAILURE);
    }

    @Override
    public void thresholdCleared(FailureThresholdAction.ThresholdInfo info) {
        logger.info("Audit logging is no longer in a failure state. Failure rate: {}%", (Object)this.formatFailureRate(info.getNumFailures()));
        this.publishNotification(info, NotificationEventType.AUDIT_LOGGING_RECOVERY);
    }

    private void publishNotification(FailureThresholdAction.ThresholdInfo info, NotificationEventType eventType) {
        String emailTemplateFile;
        NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
        String to = this.getToEmail();
        logger.info("Sending audit logging failure notification for event type {} to '{}'", (Object)eventType, (Object)to);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("eventType", eventType.toString());
        params.put("CLUSTER_MODE", (Object)ModeSupport.getMode());
        if (ModeSupport.isDistributable()) {
            params.put("IP_ADDR", this.localAddress);
            params.put("CLUSTER_INDEX", this.localNodeIndex);
        }
        params.put("FAILURE_RATE", this.formatFailureRate(info.getNumFailures()));
        params.put("CONFIGURED_THRESHOLD", info.getConfiguredThreshold());
        params.put("INTERVAL", info.getInterval());
        switch (eventType) {
            case AUDIT_LOGGING_FAILURE: {
                emailTemplateFile = "message-template-audit-logging-failure.html";
                break;
            }
            case AUDIT_LOGGING_RECOVERY: {
                emailTemplateFile = "message-template-audit-logging-recovery.html";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown event type: " + eventType);
            }
        }
        notificationSupportHelper.publishNotification(this.settings.getNotificationPublisherId(), emailTemplateFile, to, params, eventType.toString());
    }

    private String getToEmail() {
        return StringUtils.join(this.settings.getEmailsToNotify(), (String)" ");
    }

    private String formatFailureRate(double failureRate) {
        return String.format("%.2f", failureRate);
    }
}

