/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.service.impl;

import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.internal.services.interfaces.AccessTokenService;
import com.pingidentity.sdk.oauth20.IssuedAccessToken;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.Map;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.handlers.TokenManagerSelector;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.profiles.idp.AsAuditLogger;

public class AccessTokenServiceImpl
implements AccessTokenService {
    private final ClientManager clientManager = MgmtFactory.getClientManager();
    private final BearerAccessTokenMgmtPluginManager atmManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
    private final TokenManagerSelector tokenManagerSelector = new TokenManagerSelector();

    public IssuedAccessToken issue(Map<String, Object> attributes, String scopeString, String clientId, String accessTokenManagerId, AuthorizationDetails authorizationDetails) {
        Client client = this.getClient(clientId);
        if (client == null) {
            client = new Client();
            client.setClientId(clientId);
        }
        Scope scope = Scope.getScope((String)scopeString);
        TokenManagerSelector.TokenManagerSelectionQueryBuilder query = new TokenManagerSelector.TokenManagerSelectionQueryBuilder();
        query.setClient(client);
        query.setRequestedAtmId(accessTokenManagerId);
        String tokenManagerId = this.tokenManagerSelector.selectTokenManagerId(query.build());
        IssuedAccessToken issuedToken = this.atmManager.issueAccessToken(tokenManagerId, (Map<String, AttributeValue>)AttrValueSupport.convert(attributes, (boolean)false), scope, client, null, authorizationDetails);
        AsAuditLogger.setAccessTokenTrackingId(issuedToken.getTokenValue());
        AsAuditLogger.setOutAccessTokenHash(issuedToken.getTokenValue());
        return issuedToken;
    }

    private Client getClient(String clientId) {
        try {
            return this.clientManager.getCachedClient(clientId);
        }
        catch (ClientManager.ClientManagementException e) {
            AsAuditLogger.log("Database Exception");
            throw e;
        }
    }
}

