/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetail;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetailContext;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.internal.services.interfaces.AuthorizationDetailsService;
import java.util.List;
import java.util.Map;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.util.JsonPointerExpressionEvaluator;
import org.sourceid.util.ObjectMapperFactory;

public class AuthorizationDetailsServiceImpl
implements AuthorizationDetailsService {
    private final ObjectMapper mapper = ObjectMapperFactory.buildObjectMapper();

    public String toJson(AuthorizationDetails authorizationDetails) {
        return AuthorizationDetailsUtil.toJson(authorizationDetails);
    }

    public List<AuthorizationDetail> getAuthorizationDetails(String authorizationDetails) throws JsonProcessingException {
        return (List)this.mapper.readValue(authorizationDetails, (TypeReference)new TypeReference<List<AuthorizationDetail>>(){});
    }

    public AttributeValue toAttributeValue(AuthorizationDetails authorizationDetails) throws JsonProcessingException {
        String json = this.toJson(authorizationDetails);
        return JsonPointerExpressionEvaluator.convertToAttributeValue(this.mapper.readTree(json), this.mapper);
    }

    public Map<String, Object> getDetail(Map<String, Object> authorizationDetail) throws JsonProcessingException {
        String json = this.mapper.writeValueAsString(authorizationDetail);
        return (Map)this.mapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public boolean isEqualOrSubset(AuthorizationDetails requestedAuthorizationDetails, AuthorizationDetails approvedAuthorizationDetails, AuthorizationDetailContext authorizationDetailContext) {
        if (requestedAuthorizationDetails == null || requestedAuthorizationDetails.getDetails() == null) {
            return true;
        }
        return requestedAuthorizationDetails.getDetails().stream().allMatch(authorizationDetail -> AuthorizationDetailsUtil.isEqualOrSubset(authorizationDetail, approvedAuthorizationDetails, authorizationDetailContext));
    }
}

