/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.service.impl;

import com.pingidentity.sdk.internal.services.interfaces.CIDRService;
import com.pingidentity.utils.cidr.CIDRUtils;
import java.net.UnknownHostException;
import java.util.Objects;

public class CIDRServiceImpl
implements CIDRService {
    private final CIDRUtils cidrUtils;

    public CIDRServiceImpl() throws UnknownHostException {
        this.cidrUtils = null;
    }

    public CIDRServiceImpl(String cidr) throws UnknownHostException {
        this.cidrUtils = new CIDRUtils(cidr);
    }

    public String getNetworkAddress() {
        Objects.requireNonNull(this.cidrUtils, "No CIDR string was provided to the constructor.");
        return this.cidrUtils.getNetworkAddress();
    }

    public String getBroadcastAddress() {
        Objects.requireNonNull(this.cidrUtils, "No CIDR string was provided to the constructor.");
        return this.cidrUtils.getBroadcastAddress();
    }

    public boolean isInRange(String ipAddress) throws UnknownHostException {
        Objects.requireNonNull(this.cidrUtils, "No CIDR string was provided to the constructor.");
        return this.cidrUtils.isInRange(ipAddress);
    }

    public String toString() {
        Objects.requireNonNull(this.cidrUtils, "No CIDR string was provided to the constructor.");
        return this.cidrUtils.toString();
    }
}

