/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.service.impl;

import com.pingidentity.sdk.internal.services.interfaces.ClientAccessorService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ParamValues;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ClientAccessorServiceImpl
implements ClientAccessorService {
    private final ClientManager clientManager = MgmtFactory.getClientManager();

    public Map<String, ParamValues> getExtendedProperties(String clientId) {
        Client client = this.clientManager.getCachedClient(clientId);
        if (client == null) {
            return Map.of();
        }
        return client.getExtendedParams();
    }

    public Map<String, List<String>> getExtendedPropertyValues(String clientId) {
        Client client = this.clientManager.getCachedClient(clientId);
        if (client == null) {
            return Map.of();
        }
        return client.getExtendedParams().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            if (e.getValue() == null || ((ParamValues)e.getValue()).getElements() == null) {
                return Collections.emptyList();
            }
            return ((ParamValues)e.getValue()).getElements();
        }));
    }
}

