/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.service.impl;

import com.google.common.collect.ComparisonChain;
import com.pingidentity.sdk.SearchCriteria;
import com.pingidentity.sdk.internal.services.interfaces.ClientStorageManagerService;
import com.pingidentity.sdk.oauth20.ClientData;
import com.pingidentity.sdk.oauth20.ClientStorageManagementException;
import com.pingidentity.sdk.oauth20.ClientStorageManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManagerGenericImpl;

public class ClientStorageManagerServiceImpl
implements ClientStorageManagerService {
    private final ClientManagerGenericImpl clientManagerGeneric = new ClientManagerGenericImpl();

    public Collection<ClientData> search(SearchCriteria searchCriteria, ClientStorageManager clientStorageManager) throws ClientStorageManagementException {
        HashMap<String, ClientData> clientIdToClientData = new HashMap<String, ClientData>();
        ArrayList<Client> searchResults = new ArrayList<Client>();
        Collection clientDatas = clientStorageManager.getClients();
        ArrayList<Client> allClients = new ArrayList<Client>();
        for (ClientData clientData : clientDatas) {
            Client client = this.getClientFromClientData(clientData);
            if (client == null) continue;
            clientIdToClientData.put(client.getClientId(), clientData);
            allClients.add(client);
        }
        if (StringUtils.isBlank((CharSequence)searchCriteria.getQuery())) {
            searchResults = allClients;
        } else {
            for (Client client : allClients) {
                String searchCriteriaString = searchCriteria.getQuery().toLowerCase();
                if (client == null || !client.getClientId().toLowerCase().contains(searchCriteriaString) && !client.getName().toLowerCase().contains(searchCriteriaString)) continue;
                searchResults.add(client);
            }
        }
        if (searchCriteria.getStartIndex() >= searchResults.size()) {
            return Collections.emptyList();
        }
        ArrayList<Client> resultsArray = new ArrayList<Client>(searchResults);
        List orderByList = searchCriteria.getOrderBy();
        if (CollectionUtils.isNotEmpty((Collection)orderByList)) {
            SearchCriteria.OrderByItem orderBy = (SearchCriteria.OrderByItem)orderByList.get(0);
            resultsArray.sort(new ClientComparator(orderBy.getSortFieldName(), orderBy.getOrder()));
        }
        int fromIndex = searchCriteria.getStartIndex();
        int toIndex = Math.min(searchCriteria.getStartIndex() + searchCriteria.getItemsRequested(), resultsArray.size());
        return this.getClientDataArray(resultsArray.subList(fromIndex, toIndex), clientIdToClientData);
    }

    private Collection<ClientData> getClientDataArray(List<Client> clients, Map<String, ClientData> clientIdToClientData) {
        return clients.stream().map(client -> (ClientData)clientIdToClientData.get(client.getClientId())).collect(Collectors.toList());
    }

    private Client getClientFromClientData(ClientData clientData) {
        if (clientData != null) {
            return this.clientManagerGeneric.getClient(clientData);
        }
        return null;
    }

    private static class ClientComparator
    implements Comparator<Client>,
    Serializable {
        private final String sortFieldName;
        private final SearchCriteria.Order order;

        public ClientComparator(String sortFieldName, SearchCriteria.Order order) {
            this.sortFieldName = sortFieldName;
            this.order = order;
        }

        @Override
        public int compare(Client c1, Client c2) {
            int reverse = this.order == SearchCriteria.Order.ASC ? 1 : -1;
            switch (this.sortFieldName) {
                case "CLIENT_ID": {
                    return c1.getClientId().compareToIgnoreCase(c2.getClientId()) * reverse;
                }
                case "CLIENT_NAME": {
                    return c1.getName().compareToIgnoreCase(c2.getName()) * reverse;
                }
                case "LAST_MODIFIED_DATE": {
                    return ObjectUtils.compare((Comparable)c1.getLastModified(), (Comparable)c2.getLastModified()) * reverse;
                }
                case "CREATION_DATE": {
                    return ComparisonChain.start().compare((Object)c1.getCreationTime(), (Object)c2.getCreationTime(), (t1, t2) -> ObjectUtils.compare((Comparable)t1, (Comparable)t2) * reverse).compare((Object)c1.getName(), (Object)c2.getName(), String::compareToIgnoreCase).result();
                }
            }
            return 0;
        }
    }
}

