/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.service.impl;

import com.pingidentity.access.InvalidConnectionCredentialException;
import com.pingidentity.access.PingOneConnectionDisabledException;
import com.pingidentity.pingonev2.InvalidGatewayCredentialException;
import com.pingidentity.pingonev2.PingOneV2APIClient;
import com.pingidentity.sdk.internal.services.interfaces.PingOneEnvironmentAccessorService;
import java.io.IOException;
import org.apache.http.client.HttpClient;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.saml20.domain.PingOneConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PingOneConnectionsManager;

public class PingOneEnvironmentAccessorServiceImpl
implements PingOneEnvironmentAccessorService {
    private static final PingOneConnectionsManager connectionMgr = MgmtFactory.getPingOneConnectionsManager();

    public String getAuthenticationEndpoint(String connectionId, String environmentId, boolean withEnvironment) {
        PingOneConnection conn = this.getConnection(connectionId);
        String url = conn.getPingOneAuthenticationApiEndpoint();
        if (withEnvironment) {
            return url + "/" + environmentId;
        }
        return url;
    }

    public String getManagementEndpoint(String connectionId) {
        PingOneConnection conn = this.getConnection(connectionId);
        return conn.getPingOneManagementApiEndpoint();
    }

    public String getAccessToken(String connectionId) throws IOException {
        PingOneConnection conn = this.getConnection(connectionId);
        if (!conn.isActive()) {
            throw new PingOneConnectionDisabledException("Error obtaining access token. PingOne connection " + conn.getId() + " is disabled.");
        }
        try {
            PingOneV2APIClient client = new PingOneV2APIClient((HttpClient)HttpConnectionPoolingManager.getInstance().getDefaultClient(), conn.getCredential());
            return client.exchangeGatewayCredential();
        }
        catch (InvalidGatewayCredentialException e) {
            throw new InvalidConnectionCredentialException("Error exchanging credential for access token", (Throwable)e);
        }
    }

    private PingOneConnection getConnection(String connectionId) {
        PingOneConnection connection = connectionMgr.getConnection(connectionId);
        if (connection == null) {
            throw new IllegalStateException("No connection found with connection ID: " + connectionId);
        }
        return connection;
    }
}

