/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.service.impl;

import com.pingidentity.sdk.internal.services.interfaces.SessionStateSupportService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.adapter.state.SessionStateSupport;
import org.sourceid.saml20.adapter.state.TransactionalStateSupport;
import org.sourceid.saml20.domain.mgmt.AuthnSessionPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.service.InterRequestStateMgmt;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.SizeLimitProps;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.state.StateSupport;

public class SessionStateSupportServiceImpl
implements SessionStateSupportService {
    private static final String DEFAULT_VALUE_FOR_IS_ATTRIBUTE_USED_AS_LOGIN_CTX = "default-value-for-is-attribute-used-as-login-ctx";
    private static final boolean DEFAULT_VALUE_FOR_IS_ATTRIBUTE_USED_AS_LOGIN_CTX_DEFAULT_VALUE = true;
    private static final String CTX_KEY_DELIM = "ctx-key-delim";
    private static final String CTX_KEY_DELIM_DEFAULT_VALUE = "||";
    private final InterRequestStateMgmt irsm = StateMgmtFactory.getInterRequestStateMgmt();
    private final AuthnSessionPolicyManager sessionPolicyMgr;
    private final MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    private final ConfigStore sessionStateSupportConfig;
    private final ConfigStore transactionalStateSupportConfig;

    public SessionStateSupportServiceImpl() {
        this.sessionPolicyMgr = MgmtFactory.getAuthnSessionPolicyManager();
        this.sessionStateSupportConfig = ConfigStoreFarm.getConfig(SessionStateSupport.class);
        this.transactionalStateSupportConfig = ConfigStoreFarm.getConfig(TransactionalStateSupport.class);
    }

    public boolean isDefaultForUsedAsLoginCtx() {
        return this.sessionStateSupportConfig.getBooleanValue(DEFAULT_VALUE_FOR_IS_ATTRIBUTE_USED_AS_LOGIN_CTX, true);
    }

    public void setAttribute(String name, Object value, HttpServletRequest req, HttpServletResponse resp, boolean usedAsLoginCtx) {
        this.irsm.setAttribute(name, value, req, resp, usedAsLoginCtx);
    }

    public Object getAttribute(String name, HttpServletRequest req, HttpServletResponse resp) {
        return this.irsm.getAttribute(name, req, resp);
    }

    public Object removeAttribute(String name, HttpServletRequest req, HttpServletResponse resp) {
        return this.irsm.removeAttribute(name, req, resp);
    }

    public String getContextId(String resumePath) {
        StateSupport stateSupport = new StateSupport(this.localMetaData);
        return resumePath != null ? stateSupport.getContextId(resumePath) : null;
    }

    public String getContextDelimiter() {
        return this.transactionalStateSupportConfig.getStringValue(CTX_KEY_DELIM, CTX_KEY_DELIM_DEFAULT_VALUE);
    }

    public int getCapIdleTimeoutMins() {
        return this.capIdleTimeout(this.sessionPolicyMgr.getApplicationPolicy().getIdleTimeoutMins());
    }

    public int getApplicationPolicyMaxTimeoutMins() {
        return this.sessionPolicyMgr.getApplicationPolicy().getMaxTimeoutMins();
    }

    public int getCapIdleTimeoutMins(int idleTimeoutInMinutes) {
        return this.capIdleTimeout(idleTimeoutInMinutes);
    }

    public void refreshSessionInfo(HttpServletRequest req, HttpServletResponse resp) {
        IdpSessionRegistrySupport.getAuthnSessionInfo(req, resp, null);
    }

    private int capIdleTimeout(int idleTimeoutInMinutes) {
        SizeLimitProps sizeLimitProps = new SizeLimitProps();
        if (idleTimeoutInMinutes < 0) {
            return sizeLimitProps.getIdpExpiryMins();
        }
        return Math.min(idleTimeoutInMinutes, sizeLimitProps.getIdpExpiryMins());
    }
}

