/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.service.impl;

import com.pingidentity.common.util.HostAddressUtils;
import com.pingidentity.pingonev2.InvalidGatewayCredentialException;
import com.pingidentity.pingonev2.PingOneEnvironment;
import com.pingidentity.sdk.internal.services.interfaces.ValidationService;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.domain.PingOneConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PingOneConnectionsManager;

public class ValidationServiceImpl
implements ValidationService {
    private static final String P1_CONN_DOES_NOT_EXIST = "PingOne connection with ID %s does not exist.";
    private static final String P1_ENV_ID_NOT_SPECIFIED = "You must specify an environment ID.";
    private static final String P1_INVALID_GATEWAY_CREDENTIAL = "%s has an invalid gateway credential.";
    private static final String P1_API_REQUEST_FAILED = "Failed to make PingOne API request to retrieve environments.";
    private static final String P1_ENV_NOT_FOUND = "PingOne environment with ID %s does not exist or is not available.";
    private final PingOneConnectionsManager pingOneConnectionsManager = MgmtFactory.getPingOneConnectionsManager();

    public boolean isHostNameValid(String hostName) {
        return ValidationUtil.isHostnameValid(hostName) || HostAddressUtils.isIPV6Literal(hostName);
    }

    public boolean isValidUrl(String url) {
        return ValidationUtil.isValidUrl(url);
    }

    public void validatePingOneConnection(String connId, String envId) throws ValidationException {
        PingOneConnection conn = this.pingOneConnectionsManager.getConnection(connId);
        if (conn == null) {
            throw new ValidationException(String.format(P1_CONN_DOES_NOT_EXIST, connId));
        }
        if (StringUtils.isEmpty((CharSequence)envId)) {
            throw new ValidationException(P1_ENV_ID_NOT_SPECIFIED);
        }
        try {
            List<PingOneEnvironment> availableEnvs = conn.getEnvironments(false);
            for (PingOneEnvironment env : availableEnvs) {
                if (!envId.equals(env.getId())) continue;
                return;
            }
        }
        catch (InvalidGatewayCredentialException e) {
            throw new ValidationException(String.format(P1_INVALID_GATEWAY_CREDENTIAL, conn.getName()));
        }
        catch (IOException e) {
            throw new ValidationException(P1_API_REQUEST_FAILED);
        }
        throw new ValidationException(String.format(P1_ENV_NOT_FOUND, envId));
    }
}

