/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.session;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.websso.servlet.SessionIdUtil;

public class SessionQuotaContext {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final Set<String> userKeySet;

    private SessionQuotaContext(HttpServletRequest request, HttpServletResponse response, Set<String> userKeySet) {
        this.request = request;
        this.response = response;
        this.userKeySet = userKeySet;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getCurrentSessionExtendedSri() {
        return SessionIdUtil.getInstance().getExtendedSriV2(this.request, this.response, null);
    }

    public Set<String> getUserKeySet() {
        return this.userKeySet;
    }

    public static class Builder {
        private HttpServletRequest request;
        private HttpServletResponse response;
        private Set<String> userKeySet;

        public Builder setRequest(HttpServletRequest request) {
            this.request = request;
            return this;
        }

        public Builder setResponse(HttpServletResponse response) {
            this.response = response;
            return this;
        }

        public Builder setUserKeySet(Set<String> userKeySet) {
            this.userKeySet = userKeySet;
            return this;
        }

        public SessionQuotaContext build() {
            return new SessionQuotaContext(this.request, this.response, this.userKeySet);
        }
    }
}

