/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.util;

import org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;

public final class AuthnSourceKeyUtil {
    public AuthnSourceKeyUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static String storageKeyToSourceName(String storageKey) {
        AuthnSourceKey sourceKey = AuthnSourceKeyUtil.storageKeyToSourceKey(storageKey);
        if (sourceKey == null) {
            return null;
        }
        switch (sourceKey.getType()) {
            case ADAPTER: {
                IdpAuthnAdapterInstance idpAdapter = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(sourceKey.getId());
                if (idpAdapter == null) {
                    return null;
                }
                return idpAdapter.getName() + " - (Adapter)";
            }
            case IDP_CONN: {
                IdpConnection idpConn = MgmtFactory.getMetadataDirectory().getIdpConnectionBySystemId(sourceKey.getId(), false);
                if (idpConn == null) {
                    return null;
                }
                return idpConn.getName() + " - (IdP Connection)";
            }
        }
        return null;
    }

    public static AuthnSourceKey storageKeyToSourceKey(String storageKey) {
        if (storageKey == null) {
            return null;
        }
        String prefix = StringUtils.substringBefore((String)storageKey, (String)"|");
        String id = StringUtils.substringAfter((String)storageKey, (String)"|");
        if (StringUtils.isEmpty((CharSequence)prefix) || StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        if (prefix.equals(FilterableSelectionFieldDescriptor.SearchableTypeConfig.IDP_ADAPTER.getStorageKeyPrefix())) {
            return new AdapterAuthnSourceKey(id);
        }
        if (prefix.equals(FilterableSelectionFieldDescriptor.SearchableTypeConfig.IDP_CONNECTION.getStorageKeyPrefix())) {
            return new IdpConnAuthnSourceKey(id);
        }
        return null;
    }

    public static String getAuthnSourceKeyDisplayForStorage(String valueForStorage) {
        AuthnSourceKey sourceKey = AuthnSourceKeyUtil.storageKeyToSourceKey(valueForStorage);
        if (sourceKey == null) {
            return null;
        }
        switch (sourceKey.getType()) {
            case ADAPTER: {
                IdpAuthnAdapterInstance idpAdapter = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(sourceKey.getId());
                if (idpAdapter == null) {
                    return null;
                }
                return idpAdapter.getName() + " - (Adapter)";
            }
            case IDP_CONN: {
                IdpConnection idpConn = MgmtFactory.getMetadataDirectory().getIdpConnectionBySystemId(sourceKey.getId(), false);
                if (idpConn == null) {
                    return null;
                }
                return idpConn.getName() + " - (IdP Connection)";
            }
        }
        return null;
    }
}

