/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.session;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.session.AdminSessionTracker;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class LoginTracker
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final LoginTracker instance = new LoginTracker();
    private final Map<String, AdministrativeUser> currentLoggedInAdminMap = new HashMap<String, AdministrativeUser>();
    private transient HttpSession prevSession = null;

    private LoginTracker() {
    }

    public static LoginTracker getInstance() {
        return instance;
    }

    public synchronized boolean logInUser(HttpServletRequest request, AdministrativeUser user) {
        boolean flagWarningForUser;
        if (user.isAuditor()) {
            return true;
        }
        String pfConsoleLoginMode = PropertyInfo.getConsoleLoginMode();
        boolean bl = flagWarningForUser = StringUtils.isBlank((String)pfConsoleLoginMode) || "multiple".equalsIgnoreCase(pfConsoleLoginMode);
        if (this.currentLoggedInAdminMap.size() > 0 && flagWarningForUser) {
            user.setFlagWarningForUser(true);
        }
        if (this.currentLoggedInAdminMap.size() == 0 || flagWarningForUser) {
            this.currentLoggedInAdminMap.put(request.getSession().getId(), user);
            if ("single".equalsIgnoreCase(pfConsoleLoginMode)) {
                this.prevSession = request.getSession();
            }
            return true;
        }
        return false;
    }

    public synchronized void logOutUser(HttpSession session, AdministrativeUser user) {
        this.prevSession = null;
        if (user != null && !user.isAuditor()) {
            this.currentLoggedInAdminMap.remove(session.getId());
        }
    }

    public synchronized void logOutPrevSession(AdministrativeUser user) {
        if (this.prevSession == null) {
            return;
        }
        try {
            this.prevSession.isNew();
        }
        catch (IllegalStateException e) {
            this.logOutUser(this.prevSession, user);
            return;
        }
        long currentTime = new Date().getTime();
        long prevSessionExpiry = this.prevSession.getLastAccessedTime() + TimeUnit.SECONDS.toMillis(this.prevSession.getMaxInactiveInterval());
        if (currentTime > prevSessionExpiry) {
            this.logOutUser(this.prevSession, user);
        }
    }

    public synchronized List<AdministrativeUser> getCurrentLoggedInAdmins(String sessionId) {
        this.updateActiveAdmins();
        return this.currentLoggedInAdminMap.keySet().stream().filter(key -> !key.equals(sessionId)).map(this.currentLoggedInAdminMap::get).collect(Collectors.toList());
    }

    private synchronized void updateActiveAdmins() {
        Collection<String> activeAdminSessionsIds = AdminSessionTracker.getInstance().getActiveAdminSessionIds();
        Collection sessionIdsToDelete = this.currentLoggedInAdminMap.keySet().stream().filter(sessionId -> !activeAdminSessionsIds.contains(sessionId)).collect(Collectors.toList());
        sessionIdsToDelete.forEach(this.currentLoggedInAdminMap::remove);
    }

    public String getCurrentLoggedInAdmin() {
        List<AdministrativeUser> admins = this.getCurrentLoggedInAdmins(null);
        return admins.size() > 0 ? admins.get(0).getUserName() : "";
    }

    public synchronized boolean isSessionLoggedIn(String sessionId) {
        return this.currentLoggedInAdminMap.containsKey(sessionId);
    }
}

