/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.session.quotas.strategy;

import com.pingidentity.sdk.session.SessionManager;
import com.pingidentity.sdk.session.SessionQuotaContext;
import com.pingidentity.sdk.session.strategy.SessionQuotaStrategy;
import com.pingidentity.sdk.session.strategy.SessionQuotaStrategyResult;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.saml20.service.AuthnSessionInfo;

public class DestroyOldSessionsStrategy
implements SessionQuotaStrategy {
    private static final Logger logger = LoggerFactory.getLogger(DestroyOldSessionsStrategy.class);

    @Override
    public SessionQuotaStrategyResult removeSessions(String userKey, SessionQuotaContext context, Map<String, AuthnSessionInfo> sessions) {
        SessionManager sessionManager = new SessionManager();
        logger.debug("Attempting to remove all sessions for {} except the one being created.", (Object)userKey);
        if (userKey != null) {
            sessionManager.revokeOtherSessionsFor(userKey, context.getRequest(), context.getResponse());
            return new SessionQuotaStrategyResult.Builder().denyAccess(false).resultCode(SessionQuotaStrategyResult.ResultCode.SUCCESS).message("Successfully revoked all other sessions for user: " + userKey).build();
        }
        logger.warn("No user key found for session revocation");
        return new SessionQuotaStrategyResult.Builder().denyAccess(false).resultCode(SessionQuotaStrategyResult.ResultCode.FAILED_TO_ENFORCE_QUOTA).message("No unique user key provided for session revocation..").build();
    }
}

