/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sms.helper;

import com.pingidentity.pf.sms.SmsReceiverSettings;
import com.pingidentity.pf.sms.SmsSettings;
import com.pingidentity.pf.sms.util.SMSService;
import com.pingidentity.sms.SmsLanguagePackageImpl;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SmsHelper {
    private static final Logger logger = LogManager.getLogger(SmsHelper.class);
    private static final String MESSAGE_PREFIX_PASSWORD_RESET_ = "PasswordReset.";
    private static final String MESSAGE_NAME_PASSWORD_RESET_CODE = "securityCode";
    private SmsSettings smsSettings = null;

    public SmsHelper(SmsSettings smsSettings) {
        this.smsSettings = smsSettings;
    }

    public SmsSettings getSmsSettings() {
        return this.smsSettings;
    }

    public void sendPasswordResetCode(String code, String sendToNumber, Locale locale) {
        logger.debug("Starting to send password reset Code from: " + this.smsSettings.getFromNumber() + " to number: " + sendToNumber);
        SmsLanguagePackageImpl languagePack = new SmsLanguagePackageImpl(locale);
        String message = languagePack.getMessage(MESSAGE_PREFIX_PASSWORD_RESET_, MESSAGE_NAME_PASSWORD_RESET_CODE, new String[]{code});
        SmsReceiverSettings receiverSettings = new SmsReceiverSettings(sendToNumber, locale, message);
        SMSService.getService().sendMessage(this.smsSettings, receiverSettings);
    }
}

