/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.templates.mgmt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientParam;
import org.sourceid.oauth20.domain.ParamValues;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.plugin.AdapterDefaultTemplateParams;
import org.sourceid.saml20.metadata.MetaDataFactory;

public class DefaultTemplateParams {
    private static final Log log = LogFactory.getLog(DefaultTemplateParams.class);

    private DefaultTemplateParams() {
    }

    private static Map<String, Object> buildExtendedPropertiesMap(ConnectionBase connection, String clientId) {
        Client client;
        Map<String, Object> extendedProperties = new HashMap<String, Object>();
        if (connection != null) {
            String entityIdForLogging = connection.getRoleType() + " connection '" + connection.getEntityId() + "'";
            extendedProperties = DefaultTemplateParams.convertAndRemoveUnknownExtendedProperties(connection.getExtendedProperties(), entityIdForLogging);
        } else if (StringUtils.isNotBlank((String)clientId) && (client = MgmtFactory.getClientManager().getCachedClient(clientId)) != null) {
            String entityIdForLogging = "OAuth client '" + clientId + "'";
            extendedProperties = DefaultTemplateParams.convertAndRemoveUnknownExtendedProperties(client.getExtendedParams(), entityIdForLogging);
        }
        return extendedProperties;
    }

    private static Map<String, Object> convertAndRemoveUnknownExtendedProperties(Map<String, ParamValues> extendedProperties, String entityIdForLogging) {
        HashMap<String, Object> extendedPropertiesObjectValue = new HashMap<String, Object>();
        for (Map.Entry<String, ParamValues> entry : extendedProperties.entrySet()) {
            Object value = DefaultTemplateParams.getExtendedPropertyValue(entry.getKey(), entry.getValue().getElements());
            if (value != null) {
                extendedPropertiesObjectValue.put(entry.getKey(), value);
                continue;
            }
            log.warn((Object)(entityIdForLogging + " is using an unknown extended property '" + entry.getKey() + "'. The unknown extended property will be ignored."));
        }
        return extendedPropertiesObjectValue;
    }

    private static Object getExtendedPropertyValue(String propertyName, List<String> values) {
        Map<String, ClientParam> propertyDefinitions;
        Object value = null;
        if (CollectionUtils.isNotEmpty(values) && (propertyDefinitions = MgmtFactory.getClientSettingManager().getExtendedProperties()).containsKey(propertyName)) {
            value = propertyDefinitions.get(propertyName).isMultiValued() ? values : values.get(0);
        }
        return value;
    }

    private static void addParam(Map<String, Object> templateParams, String paramName, Object paramValue) {
        if (paramValue != null) {
            templateParams.put(paramName, paramValue);
        }
    }

    public static class Builder {
        private Role role;
        private String adapterId;
        private String baseUrl;
        private String clientId;
        private String clientName;
        private String connectionName;
        private String entityId;
        private String spAdapterId;
        private String oidcUiLocalesStr;

        public Builder(Role role) {
            this.role = role;
        }

        public Builder adapterId(String adapterId) {
            this.adapterId = adapterId;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder spAdapterId(String spAdapterId) {
            this.spAdapterId = spAdapterId;
            return this;
        }

        public Builder oidcUiLocalesStr(String oidcUiLocalesStr) {
            this.oidcUiLocalesStr = oidcUiLocalesStr;
            return this;
        }

        public Map<String, Object> build() {
            HashMap<String, Object> templateParameters = new HashMap<String, Object>();
            DefaultTemplateParams.addParam(templateParameters, AdapterDefaultTemplateParams.ADAPTER_ID.getParamName(), this.adapterId);
            DefaultTemplateParams.addParam(templateParameters, AdapterDefaultTemplateParams.BASE_URL.getParamName(), this.baseUrl);
            DefaultTemplateParams.addParam(templateParameters, AdapterDefaultTemplateParams.CLIENT_ID.getParamName(), this.clientId);
            DefaultTemplateParams.addParam(templateParameters, AdapterDefaultTemplateParams.CLIENT_NAME.getParamName(), this.clientName);
            DefaultTemplateParams.addParam(templateParameters, AdapterDefaultTemplateParams.CONNECTION_NAME.getParamName(), this.connectionName);
            DefaultTemplateParams.addParam(templateParameters, AdapterDefaultTemplateParams.ENTITY_ID.getParamName(), this.entityId);
            DefaultTemplateParams.addParam(templateParameters, AdapterDefaultTemplateParams.SP_ADAPTER_ID.getParamName(), this.spAdapterId);
            DefaultTemplateParams.addParam(templateParameters, AdapterDefaultTemplateParams.OIDC_UI_LOCALES.getParamName(), this.oidcUiLocalesStr);
            ConnectionBase conn = this.role.equals((Object)Role.SP) ? MetaDataFactory.getMetadataDirectory().getIdpConnection(this.entityId, false) : MetaDataFactory.getMetadataDirectory().getSpConnection(this.entityId, false);
            Map<String, Object> extendedProperties = DefaultTemplateParams.buildExtendedPropertiesMap(conn, this.clientId);
            if (MapUtils.isNotEmpty(extendedProperties)) {
                DefaultTemplateParams.addParam(templateParameters, AdapterDefaultTemplateParams.EXTENDED_PROPERTIES.getParamName(), extendedProperties);
            }
            return templateParameters;
        }
    }

    public static enum Role {
        IDP,
        SP;

    }
}

