/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.templates.mgmt;

import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.templates.mgmt.TemplateFileManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;

public class SaaSLdapTemplateFileManager
extends TemplateFileManager
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private static final SaaSLdapTemplateFileManager saasLdapTemplateFileMgr = new SaaSLdapTemplateFileManager();
    private static final Log log = LogFactory.getLog(SaaSLdapTemplateFileManager.class);
    private final SysDirInfo sysDirInfo = GlobalRegistry.getService(SysDirInfo.class);
    private Map<String, Properties> templates = new HashMap<String, Properties>();
    private List<String> exampleFilesAlreadyLogged = new ArrayList<String>();
    private List<String> missingTemplateNameFilesAlreadyLogged = new ArrayList<String>();
    public static final String TEMPLATE_NAME = "template.name";
    private static final String EXAMPLE_FILE = "example";
    public static final String TEMPLATE_TYPE = "template.type";

    private SaaSLdapTemplateFileManager() {
    }

    public static SaaSLdapTemplateFileManager getInstance() {
        return saasLdapTemplateFileMgr;
    }

    public List<String> getSaaSLdapTemplateNameList() {
        this.refresh();
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(this.templates.keySet());
        return l;
    }

    public Map<String, String> getSaaSLdapTemplateNameToTypeMap() {
        this.refresh();
        HashMap<String, String> m = new HashMap<String, String>();
        for (String k : this.templates.keySet()) {
            Properties p = this.templates.get(k);
            String t = p.getProperty(TEMPLATE_TYPE);
            String v = !StringUtils.isBlank((String)t) ? t : LdapInfo.LdapType.Custom.toString();
            m.put(k, v);
        }
        return m;
    }

    public Properties getSaaSLdapTemplateProperties(String selectedSaaSLdapTemplateName) {
        this.refresh();
        for (Map.Entry<String, Properties> e : this.templates.entrySet()) {
            if (!e.getKey().equals(selectedSaaSLdapTemplateName)) continue;
            return e.getValue();
        }
        log.warn((Object)("Template properties for '" + selectedSaaSLdapTemplateName + "' not found.  Properties not loaded."));
        return null;
    }

    private void refresh() {
        this.templates.clear();
        String path = this.sysDirInfo.getLdapTemplateDirectory();
        List<File> templateFiles = this.getTemplateFiles(path, false);
        if (templateFiles != null && !templateFiles.isEmpty()) {
            for (File f : templateFiles) {
                Properties p = new Properties();
                try {
                    p.load(new FileInputStream(f));
                    String name = p.getProperty(TEMPLATE_NAME);
                    if (StringUtils.isBlank((String)name)) {
                        if (this.missingTemplateNameFilesAlreadyLogged.contains(f.getName())) continue;
                        log.debug((Object)("File: " + f + " was not added to the Ldap Templates because it is missing template.name"));
                        this.missingTemplateNameFilesAlreadyLogged.add(f.getName());
                        if (this.missingTemplateNameFilesAlreadyLogged.size() <= 100) continue;
                        this.missingTemplateNameFilesAlreadyLogged.clear();
                        continue;
                    }
                    if (EXAMPLE_FILE.equalsIgnoreCase(name)) {
                        if (this.exampleFilesAlreadyLogged.contains(f.getName())) continue;
                        log.debug((Object)("File: " + f + " was not added to the Ldap Templates because it is labeled as an example file"));
                        this.exampleFilesAlreadyLogged.add(f.getName());
                        if (this.exampleFilesAlreadyLogged.size() <= 100) continue;
                        this.exampleFilesAlreadyLogged.clear();
                        continue;
                    }
                    this.templates.put(name, p);
                }
                catch (IOException e) {
                    log.error((Object)("There was a problem reading in the LDAP template file: " + f.getName()));
                    log.error((Object)("Error: " + e));
                }
            }
        }
    }
}

