/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.util;

import com.pingidentity.common.util.PropertyInfo;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdminBaseUrlUtil {
    private static final Log log = LogFactory.getLog(AdminBaseUrlUtil.class);

    public static StringBuilder getAdminBaseUrl(String contextPath) {
        StringBuilder basePath = new StringBuilder();
        if (StringUtils.isNotBlank((String)PropertyInfo.getAdminBaseUrl())) {
            basePath.append(PropertyInfo.getAdminBaseUrl());
        } else {
            String port = PropertyInfo.getAdminHttpsPort();
            String hostname = PropertyInfo.getAdminHostname();
            if (StringUtils.isBlank((String)hostname)) {
                try {
                    hostname = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    hostname = "localhost";
                }
            }
            basePath.append("https://");
            basePath.append(hostname);
            basePath.append(":");
            basePath.append(port);
        }
        if (contextPath != null) {
            basePath.append(contextPath);
        }
        try {
            URI uri = new URI(basePath.toString());
            basePath = new StringBuilder(uri.normalize().toString());
        }
        catch (URISyntaxException syntaxException) {
            log.error((Object)String.format("Could not normalize base path '%s'.", basePath), (Throwable)syntaxException);
        }
        return basePath;
    }

    public static StringBuilder getAdminBaseUrlFromServletRequest(HttpServletRequest req) {
        String hostname = req.getServerName();
        if (StringUtils.isBlank((String)hostname)) {
            log.debug((Object)"No hostname found in request, using admin hostname from PingFederate properties.");
            hostname = PropertyInfo.getAdminHostname();
        }
        int port = AdminBaseUrlUtil.getPort(req);
        String scheme = req.getScheme();
        StringBuilder basePath = new StringBuilder();
        basePath.append(scheme);
        basePath.append("://");
        basePath.append(hostname);
        if (port != -1) {
            basePath.append(":");
            basePath.append(port);
        }
        return basePath;
    }

    private static int getPort(HttpServletRequest req) {
        if ("http".equals(req.getScheme()) && req.getServerPort() == 80 || "https".equals(req.getScheme()) && req.getServerPort() == 443) {
            return -1;
        }
        return req.getServerPort();
    }
}

