/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.util;

import java.util.HashMap;
import java.util.Map;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;

public class InitialSetupConfigStore {
    public static final String LICENSE_MAP = "license-map";
    public static final String KEY = "key";
    public static final String HAS_CONFIGURED_SERVER_SETTINGS = "hasConfiguredServerSettings";
    public static final String INITIAL_SETUP_DONE = "initial-setup-done";
    public static final String CONFIG_STORE_FILENAME = "com.pingidentity.page.Login";
    public static final ConfigStore configStore = ConfigStoreFarm.getConfig("com.pingidentity.page.Login");
    public static final String LICENSE_AGREEMENT_ACCEPTED = "license-agreement-accepted";

    public synchronized boolean isInitialSetupDone() {
        if (this.isLegacyFlagSet() || this.isLegacyConfiguredServerSettingsFlagSet()) {
            return true;
        }
        return this.getLicenseMapValue(INITIAL_SETUP_DONE);
    }

    public synchronized boolean hasAcceptedLicenseAgreement() {
        if (this.isLegacyFlagSet()) {
            return true;
        }
        return this.getLicenseMapValue(LICENSE_AGREEMENT_ACCEPTED);
    }

    public synchronized void acceptLicense() {
        Map acceptMap = configStore.getMapValue(LICENSE_MAP, new HashMap());
        acceptMap.put(LICENSE_AGREEMENT_ACCEPTED, "true");
        configStore.setMapValue(LICENSE_MAP, acceptMap);
    }

    public synchronized void setInitialSetupDone() {
        Map acceptMap = configStore.getMapValue(LICENSE_MAP, new HashMap());
        acceptMap.put(INITIAL_SETUP_DONE, "true");
        configStore.setMapValue(LICENSE_MAP, acceptMap);
        configStore.setBooleanValue("disable-multitab-alert", false);
    }

    private boolean isLegacyFlagSet() {
        return this.getLicenseMapValue(KEY);
    }

    public boolean isLegacyConfiguredServerSettingsFlagSet() {
        return this.getLicenseMapValue(HAS_CONFIGURED_SERVER_SETTINGS);
    }

    private boolean getLicenseMapValue(String key) {
        Map acceptMap = configStore.getMapValue(LICENSE_MAP, new HashMap());
        if (acceptMap.get(key) != null) {
            String value = (String)acceptMap.get(key);
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    public static void reload() {
        configStore.reload();
    }
}

