/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.util;

import com.pingidentity.common.util.ObfuscationException;
import com.pingidentity.crypto.PasswordFile;
import com.pingidentity.crypto.SecurityProviderUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.impl.util.HexBin;

public class LegacyDecryptionUtil {
    private static final Logger log = LogManager.getLogger(LegacyDecryptionUtil.class);

    public String decryptLegacyHsmPwdFile(File inFile) {
        String encryptedPwd = PasswordFile.getObfuscatedHSMPassword(inFile);
        if (encryptedPwd != null) {
            return this.seedBasedDecryption(encryptedPwd);
        }
        return null;
    }

    private String seedBasedDecryption(String inStr) {
        byte[] decryptedBytes;
        Cipher cipher = this.getCipher();
        try {
            byte[] bytes = HexBin.stringToBytes((String)inStr);
            decryptedBytes = cipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new ObfuscationException("Error occurred de-obfuscating", (Throwable)e);
        }
        return new String(decryptedBytes, StandardCharsets.UTF_8);
    }

    private SecretKeySpec getSecretKeySpec() {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
            secureRandom.setSeed(100004328L);
            KeyGenerator kgen = KeyGenerator.getInstance("AES", SecurityProviderUtil.getSunJCEProviderOrEquivalent());
            kgen.init(secureRandom);
            SecretKey secretKey = kgen.generateKey();
            byte[] bytes = secretKey.getEncoded();
            return new SecretKeySpec(bytes, "AES");
        }
        catch (GeneralSecurityException e) {
            throw new ObfuscationException("Error occurred creating SecretKeySpec");
        }
    }

    private Cipher getCipher() {
        try {
            Cipher cipher = Cipher.getInstance("AES", SecurityProviderUtil.getSunJCEProviderOrEquivalent());
            cipher.init(2, this.getSecretKeySpec());
            return cipher;
        }
        catch (Exception e) {
            throw new ObfuscationException("Error occurred creating cipher", (Throwable)e);
        }
    }
}

