/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryParams {
    private static final Log log = LogFactory.getLog(QueryParams.class);
    private Map<String, List<String>> params = new HashMap<String, List<String>>();

    public QueryParams() {
    }

    public QueryParams(HttpServletRequest req) {
        Map paramMap = req.getParameterMap();
        paramMap.forEach((param, values) -> this.put((String)param, Arrays.asList(values)));
    }

    public void put(String paramName, String value) {
        if (!this.params.containsKey(paramName)) {
            this.params.put(paramName, new LinkedList());
        }
        this.params.get(paramName).add(value);
    }

    public void put(String paramName, List<String> values) {
        if (!this.params.containsKey(paramName)) {
            this.params.put(paramName, new LinkedList());
        }
        this.params.get(paramName).addAll(values);
    }

    public String getQueryParamString() {
        StringBuilder builder = new StringBuilder();
        AtomicInteger count = new AtomicInteger();
        this.params.forEach((paramName, values) -> {
            values.forEach(value -> {
                try {
                    builder.append((String)paramName).append("=").append(URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)("Unable to encode query param '" + paramName + "' due to: " + e.getMessage()), (Throwable)e);
                }
            });
            if (count.incrementAndGet() < this.params.size()) {
                builder.append("&");
            }
        });
        return builder.toString();
    }
}

