/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.ws;

import com.pingidentity.ws.AdapterInstanceContextInfo;
import com.pingidentity.ws.ConnectionEntity;
import com.pingidentity.ws.ExtAdapterInstanceContextInfo;
import com.pingidentity.ws.NameId;
import com.pingidentity.ws.SSODirectoryServiceSupport;
import com.pingidentity.ws.SSOEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.a2a.domain.mgmt.Adapter2AdapterManager;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.SpAdapterManager;
import org.sourceid.saml20.domain.util.filter.ConnectionFilter;
import org.sourceid.saml20.domain.util.filter.FilterCriteria;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.MetadataLocalHelper;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.websso.Protocol;

public class SSODirectoryService {
    private final ConnectionFilter spFilter;
    private final ConnectionFilter idpFilter;
    private final MetadataLocal localMetadata;
    private final MetadataDirectory metadataDirectory;
    private final IdpAdapterManager idpAdapterMgr;
    private final SpAdapterManager spAdapterMgr;
    private final ConnectionManager connMgr;

    public SSODirectoryService() {
        FilterCriteria spCriteria = new FilterCriteria();
        spCriteria.setRoles(Role.SP);
        spCriteria.setProtocols(Protocol.SAML10, Protocol.SAML11, Protocol.SAML20);
        spCriteria.setActive(true);
        spCriteria.setIdpInitSSO(true);
        this.spFilter = new ConnectionFilter(spCriteria);
        FilterCriteria idpCriteria = new FilterCriteria();
        idpCriteria.setRoles(Role.IDP);
        idpCriteria.setActive(true);
        idpCriteria.setSpInitSSO(true);
        this.idpFilter = new ConnectionFilter(idpCriteria);
        this.localMetadata = MetaDataFactory.getLocalMetaData();
        this.metadataDirectory = MetaDataFactory.getMetadataDirectory();
        this.idpAdapterMgr = MgmtFactory.getIdpAdapterManager();
        this.spAdapterMgr = MgmtFactory.getSpAdapterManager();
        this.connMgr = MgmtFactory.getConnectionManager();
    }

    public SSOEntity[] getIDPList() {
        Collection<IdpConnection> idpConns = this.metadataDirectory.getIdpConnections();
        Collection<ConnectionBase> filtered = this.idpFilter.filter(idpConns);
        Set<Protocol> enabledSpProtocols = this.localMetadata.getEnabledSpProtocols();
        return this.getSSOEntityList(filtered, enabledSpProtocols);
    }

    public ConnectionEntity[] getFullIDPList() {
        Collection<IdpConnection> connections = this.metadataDirectory.getIdpConnections();
        ConnectionEntity[] entityList = new ConnectionEntity[connections.size()];
        int idx = 0;
        for (ConnectionBase connectionBase : connections) {
            String name = connectionBase.getName();
            ConnectionEntity entity = new ConnectionEntity();
            entity.setEntityId(connectionBase.getEntityId());
            entity.setName(name);
            entity.setProtocol(connectionBase.getProtocol().toString());
            if (connectionBase.getDefaultVirtualIdentity() != null) {
                entity.setVirtualId(VirtualIdentityUtil.getDefaultVirtualIdForRuntime(connectionBase).getVirtualEntityId(DomainMode.RUNTIME));
            }
            entity.setActive(connectionBase.isActive());
            entity.setRole(Role.IDP.toString());
            entityList[idx++] = entity;
        }
        return entityList;
    }

    public SSOEntity[] getSPList() {
        Collection<SpConnection> spConns = this.metadataDirectory.getSpConnections();
        Collection<ConnectionBase> filtered = this.spFilter.filter(spConns);
        Set<Protocol> enabledSpProtocols = this.localMetadata.getEnabledIdpProtocols();
        return this.getSSOEntityList(filtered, enabledSpProtocols);
    }

    public ConnectionEntity[] getFullSPList() {
        Collection<SpConnection> connections = this.metadataDirectory.getSpConnections();
        ConnectionEntity[] entityList = new ConnectionEntity[connections.size()];
        int idx = 0;
        for (ConnectionBase connectionBase : connections) {
            String name = connectionBase.getName();
            ConnectionEntity entity = new ConnectionEntity();
            entity.setEntityId(connectionBase.getEntityId());
            entity.setName(name);
            entity.setProtocol(connectionBase.getProtocol().toString());
            if (connectionBase.getDefaultVirtualIdentity() != null) {
                entity.setVirtualId(VirtualIdentityUtil.getDefaultVirtualIdForRuntime(connectionBase).getVirtualEntityId(DomainMode.RUNTIME));
            }
            entity.setActive(connectionBase.isActive());
            entity.setRole(Role.SP.toString());
            entityList[idx++] = entity;
        }
        return entityList;
    }

    public NameId[] getIdpAdapterInstanceList() {
        Collection idpAuthnAdapterInstances = this.idpAdapterMgr.getInstances();
        return this.instancesToNameIds(idpAuthnAdapterInstances);
    }

    public NameId[] getAdapterInstanceList() {
        Collection adapterInstances = this.spAdapterMgr.getInstances();
        return this.instancesToNameIds(adapterInstances);
    }

    public AdapterInstanceContextInfo[] getIdpAdapterInstanceInfoByUsageList() {
        Collection allIdpAdapters = this.idpAdapterMgr.getInstances();
        HashMap<IdpAuthnAdapterInstance, List<SpConnection>> spConns = new HashMap<IdpAuthnAdapterInstance, List<SpConnection>>();
        for (IdpAuthnAdapterInstance instance : allIdpAdapters) {
            List<SpConnection> spConnections = this.connMgr.getSpConnectionsUsingAdapterInstance(instance.getId());
            if (spConnections == null || spConnections.isEmpty()) continue;
            spConns.put(instance, spConnections);
        }
        HashMap<IdpAuthnAdapterInstance, List<Direct2SpAdapterMapping>> a2aMappings = new HashMap<IdpAuthnAdapterInstance, List<Direct2SpAdapterMapping>>();
        Adapter2AdapterManager a2aMgr = MgmtFactory.getAdapter2AdapterManager();
        for (IdpAuthnAdapterInstance instance : allIdpAdapters) {
            if (!a2aMgr.isSourceInUse(instance.getId())) continue;
            a2aMappings.put(instance, a2aMgr.getMappingsMappedToSource(instance.getId()));
        }
        ArrayList<AdapterInstanceContextInfo> adapterContextInfoList = new ArrayList<AdapterInstanceContextInfo>();
        SSODirectoryServiceSupport support = SSODirectoryServiceSupport.getInstance();
        adapterContextInfoList.addAll(support.buildCloudConnectorListFromConnections(spConns));
        adapterContextInfoList.addAll(support.buildCloudConnectorListFromA2A(a2aMappings));
        String baseUrl = MetaDataFactory.getLocalMetaData().getBaseUrl();
        AdapterInstanceContextInfo[] instanceList = new AdapterInstanceContextInfo[adapterContextInfoList.size()];
        int i = 0;
        for (AdapterInstanceContextInfo instance : adapterContextInfoList) {
            instance.setBaseUrl(baseUrl);
            instanceList[i++] = instance;
        }
        return instanceList;
    }

    public ExtAdapterInstanceContextInfo[] getAdapterInstancesInfoByUsage() {
        Collection allIdpAdapters = this.idpAdapterMgr.getInstances();
        HashMap<IdpAuthnAdapterInstance, List<SpConnection>> spConns = new HashMap<IdpAuthnAdapterInstance, List<SpConnection>>();
        for (IdpAuthnAdapterInstance instance : allIdpAdapters) {
            List<SpConnection> spConnections = this.connMgr.getSpConnectionsUsingAdapterInstance(instance.getId());
            if (spConnections == null || spConnections.isEmpty()) continue;
            spConns.put(instance, spConnections);
        }
        Collection allSpAdapters = this.spAdapterMgr.getInstances();
        HashMap<AuthnAdapterInstance, List<IdpConnection>> idpConns = new HashMap<AuthnAdapterInstance, List<IdpConnection>>();
        for (AuthnAdapterInstance instance : allSpAdapters) {
            List<IdpConnection> idpConnections = this.connMgr.getIdpConnectionsUsingAdapterInstance(instance.getId());
            if (idpConnections == null || idpConnections.isEmpty()) continue;
            idpConns.put(instance, idpConnections);
        }
        HashMap<IdpAuthnAdapterInstance, List<Direct2SpAdapterMapping>> a2aMappings = new HashMap<IdpAuthnAdapterInstance, List<Direct2SpAdapterMapping>>();
        Adapter2AdapterManager a2aMgr = MgmtFactory.getAdapter2AdapterManager();
        for (IdpAuthnAdapterInstance instance : allIdpAdapters) {
            if (!a2aMgr.isSourceInUse(instance.getId())) continue;
            a2aMappings.put(instance, a2aMgr.getMappingsMappedToSource(instance.getId()));
        }
        ArrayList<ExtAdapterInstanceContextInfo> extAdapterContextInfoList = new ArrayList<ExtAdapterInstanceContextInfo>();
        SSODirectoryServiceSupport support = SSODirectoryServiceSupport.getInstance();
        extAdapterContextInfoList.addAll(support.buildListFromIdPConnections(idpConns));
        extAdapterContextInfoList.addAll(support.buildListFromSPConnections(spConns));
        extAdapterContextInfoList.addAll(support.buildListFromA2A(a2aMappings));
        String baseUrl = this.localMetadata.getBaseUrl();
        String spSsoSuccessUrl = MetadataLocalHelper.getSpSsoSuccessUrl(this.localMetadata);
        ExtAdapterInstanceContextInfo[] instanceList = new ExtAdapterInstanceContextInfo[extAdapterContextInfoList.size()];
        int i = 0;
        for (ExtAdapterInstanceContextInfo instance : extAdapterContextInfoList) {
            instance.setBaseUrl(baseUrl);
            if (StringUtils.isNotBlank((String)spSsoSuccessUrl)) {
                instance.setSpSsoSuccessUrl(spSsoSuccessUrl);
            }
            instanceList[i++] = instance;
        }
        return instanceList;
    }

    private NameId[] instancesToNameIds(Collection<? extends AuthnAdapterInstance> adapterInstances) {
        int count = adapterInstances.size();
        NameId[] adapterInstanceNames = new NameId[count];
        int i = 0;
        for (AuthnAdapterInstance authnAdapterInstance : adapterInstances) {
            adapterInstanceNames[i++] = new NameId(authnAdapterInstance.getId(), authnAdapterInstance.getName());
        }
        return adapterInstanceNames;
    }

    private SSOEntity[] getSSOEntityList(Collection<ConnectionBase> connections, Set<Protocol> enabledLocalProtocols) {
        FilterCriteria filterCriteria = new FilterCriteria();
        ConnectionFilter filter = new ConnectionFilter(filterCriteria);
        filterCriteria.setProtocols(enabledLocalProtocols.toArray(new Protocol[enabledLocalProtocols.size()]));
        connections = filter.filter(connections);
        SSOEntity[] entityList = new SSOEntity[connections.size()];
        int idx = 0;
        for (ConnectionBase conn : connections) {
            String name = conn.getName();
            entityList[idx++] = new SSOEntity(conn.getEntityId(), name);
        }
        return entityList;
    }
}

