/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.a2a;

import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.a2a.domain.mgmt.Adapter2AdapterManager;
import org.sourceid.saml20.domain.ProxyScoping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.MetadataLocalHelper;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupportBase;
import org.sourceid.saml20.profiles.idp.authn.MappedAuthnSourcesAndApcs;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.wrapper.BaseMessageContext;

public class Adapter2AdapterMappingIdpAdapterSupport
extends AuthnSourceSupportBase {
    private final Adapter2AdapterManager adapter2AdapterManager = MgmtFactory.getAdapter2AdapterManager();
    private final MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();

    @Override
    protected MappedAuthnSourcesAndApcs getMappedSources(HttpServletRequest req, Map<String, Object> stateParams, BaseMessageContext messageContext, ProxyScoping proxyScoping) {
        String spAdapterId = (String)stateParams.get("SpSessionAuthnAdapterId");
        HashSet<AuthnSourceKey> authnSourceKeys = new HashSet<AuthnSourceKey>();
        if (MetadataLocalHelper.isEnableIdp(this.localMetaData)) {
            for (Direct2SpAdapterMapping a2aMapping : this.adapter2AdapterManager.getMappingsUsingTarget(spAdapterId)) {
                if (this.adapterManager.getIdpAuthnAdapterInstance(a2aMapping.getSourceId()) == null) continue;
                authnSourceKeys.add(new AdapterAuthnSourceKey(a2aMapping.getSourceId()));
            }
        }
        if (authnSourceKeys.isEmpty()) {
            throw new ProcessRuntimeException("No adapter-to-adapter mappings are configured that map into the given SP Adapter Instance: " + spAdapterId);
        }
        return new MappedAuthnSourcesAndApcs(authnSourceKeys, null);
    }

    @Override
    protected String makeNoMappingErrMsg(Map<String, Object> stateParams, String escapedParam) {
        String spAdapterId = (String)stateParams.get("SpSessionAuthnAdapterId");
        StringBuilder sb = new StringBuilder();
        sb.append("IdpAdapterId").append(" was specified as ").append(escapedParam);
        sb.append(" but no adapter-to-adapter mapping exists from that IdP Adapter to the given SP Adapter: ");
        sb.append(spAdapterId);
        return sb.toString();
    }

    @Override
    protected void addApplicationNameImage(Map<String, Object> stateParams, AuthnSourceKey authnSourceKey) {
        String idpAdapterId;
        Direct2SpAdapterMapping mapping;
        String spAdapterApplicationIconUrl;
        String spAdapterId = (String)stateParams.get("SpSessionAuthnAdapterId");
        String spAdapterApplicationName = this.getSpAdapterApplicationName(spAdapterId);
        if (StringUtils.isNotBlank((String)spAdapterApplicationName)) {
            stateParams.put("applicationName", spAdapterApplicationName);
        }
        if (StringUtils.isNotBlank((String)(spAdapterApplicationIconUrl = this.getSpAdapterApplicationIconUrl(spAdapterId)))) {
            stateParams.put("applicationIcon", spAdapterApplicationIconUrl);
        }
        if ((mapping = (Direct2SpAdapterMapping)this.adapter2AdapterManager.getMapping(idpAdapterId = authnSourceKey != null ? authnSourceKey.getId() : null, spAdapterId)) != null) {
            if (StringUtils.isNotBlank((String)mapping.getApplicationName())) {
                stateParams.put("applicationName", mapping.getApplicationName());
            }
            if (mapping.getApplicationIconUrl() != null) {
                stateParams.put("applicationIcon", mapping.getApplicationIconUrl().toExternalForm());
            }
        }
    }
}

