/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.a2a.domain.mgmt;

import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.a2a.domain.mgmt.Source2TargetManagerImpl;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.source2target.xmlbinding.Source2TargetPluginMappingType;

public abstract class Direct2SpAdapterManagerImpl
extends Source2TargetManagerImpl<Direct2SpAdapterMapping> {
    public Direct2SpAdapterManagerImpl(XmlLoader xmlLoader, SysDirInfo sysDirInfo, Mediator mediator) {
        super(xmlLoader, sysDirInfo, mediator);
    }

    Direct2SpAdapterManagerImpl(XmlLoader xmlLoader, String dir) {
        super(xmlLoader, dir);
    }

    public String getTargetUrl(String sourceId, String spAdapterId) {
        Collection mappings = this.getMappings();
        Iterator i = mappings.iterator();
        boolean spAdapterBlank = StringUtils.isBlank((String)spAdapterId);
        boolean idpAdapterBlank = StringUtils.isBlank((String)sourceId);
        if (spAdapterBlank || idpAdapterBlank) {
            if (mappings.size() == 1) {
                Direct2SpAdapterMapping mapping = (Direct2SpAdapterMapping)i.next();
                return mapping.getDefaultTargetResource();
            }
        } else if (!spAdapterBlank && !idpAdapterBlank) {
            while (i.hasNext()) {
                Direct2SpAdapterMapping mapping = (Direct2SpAdapterMapping)i.next();
                if (!mapping.getTargetId().equals(spAdapterId) || !mapping.getSourceId().equals(sourceId)) continue;
                return mapping.getDefaultTargetResource();
            }
        }
        return "";
    }

    @Override
    protected Direct2SpAdapterMapping makeMapping() {
        return new Direct2SpAdapterMapping();
    }

    @Override
    public Direct2SpAdapterMapping createEmptyMapping() {
        return new Direct2SpAdapterMapping();
    }

    @Override
    protected void loadAdditionalAttributesFromXml(Source2TargetMapping source2TargetMapping, Source2TargetPluginMappingType s2tMappingType) {
        String urlStr;
        Direct2SpAdapterMapping a2aSource2TargetMapping = (Direct2SpAdapterMapping)source2TargetMapping;
        if (s2tMappingType.isSetApplicationName()) {
            a2aSource2TargetMapping.setApplicationName(s2tMappingType.getApplicationName());
        }
        if (s2tMappingType.isSetApplicationIcon() && StringUtils.isNotBlank((String)(urlStr = s2tMappingType.getApplicationIcon()))) {
            URL url = null;
            try {
                url = new URL(urlStr);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            a2aSource2TargetMapping.setApplicationIconUrl(url);
        }
    }

    @Override
    protected void saveAdditionalAttributesToXml(Source2TargetMapping mapping, Source2TargetPluginMappingType source2TargetMappingType) {
        Direct2SpAdapterMapping a2aMapping = (Direct2SpAdapterMapping)mapping;
        if (StringUtils.isNotBlank((String)a2aMapping.getApplicationName())) {
            source2TargetMappingType.setApplicationName(a2aMapping.getApplicationName());
        }
        if (a2aMapping.getApplicationIconUrl() != null) {
            URL applicationIconUrl = a2aMapping.getApplicationIconUrl();
            String applicationIconUrlStr = applicationIconUrl.toExternalForm();
            source2TargetMappingType.setApplicationIcon(applicationIconUrlStr);
        }
    }
}

