/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.auth;

import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.auth.BasicAuth;
import org.sourceid.auth.CertAuth;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.config.SoapAuthStore;
import org.sourceid.config.SoapAuthStoreFactory;

public class Authenticator {
    private static final Log log = LogFactory.getLog(Authenticator.class);
    private static final String ATTR_NAME = AuthnInfo.class.getName();
    private static final SoapAuthStore store = SoapAuthStoreFactory.getSoapAuthStore();
    private static final BasicAuth basicAuth = new BasicAuth(store);
    private static final CertAuth certAuth = new CertAuth(store);

    public static AuthnInfo authn(HttpServletRequest req, HttpServletResponse resp) throws LoginException {
        AuthnInfo authnInfo = null;
        Object o = req.getAttribute(ATTR_NAME);
        try {
            authnInfo = (AuthnInfo)o;
        }
        catch (ClassCastException e) {
            log.warn((Object)("Bad class cast looking for AuthnInfo but found " + o + ". " + e));
        }
        if (authnInfo == null) {
            String certUserId = certAuth.doCertAuth(req, resp);
            String basicUserId = basicAuth.doBasicAuth(req);
            authnInfo = Authenticator.getAuthnInfo(certUserId, basicUserId);
            req.setAttribute(ATTR_NAME, (Object)authnInfo);
        }
        return authnInfo;
    }

    public static boolean checkAuthnInfo(AuthnInfo authnInfo, String encodedId, boolean isRequestSecure) throws LoginException {
        SoapAuthInfo incoming = store.getIncoming(encodedId);
        boolean hasNoneEntry = incoming.isHasNoneEntry();
        String principalName = authnInfo.getId();
        if (!(encodedId.equals(principalName) || hasNoneEntry && principalName == null)) {
            StringBuffer msg = new StringBuffer("SOAP client request not properly authenticated. ");
            msg.append("SAML message Issuer=").append(encodedId).append(". ");
            msg.append("Authenticated identity=").append(principalName);
            String message = msg.toString();
            log.warn((Object)message);
            throw new LoginException(message);
        }
        if (incoming.isHasBasicEntry() && !authnInfo.isProvidedBasic()) {
            throw new LoginException("Basic auth credentials must be provided for " + encodedId);
        }
        if (incoming.isHasCertEntry() && !authnInfo.isProvidedCert()) {
            throw new LoginException("Cert auth credentials must be provided for " + encodedId);
        }
        if (incoming.isSsl() && !isRequestSecure) {
            log.warn((Object)("SSL is required for " + encodedId));
            throw new LoginException("SSL is required inbound for " + encodedId);
        }
        return !hasNoneEntry;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static AuthnInfo getAuthnInfo(String certUserId, String basicUserId) throws LoginException {
        AuthnInfo authnInfo = new AuthnInfo();
        if (certUserId != null && basicUserId != null) {
            if (!certUserId.equals(basicUserId)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Authn mismatch: id from cert='").append(certUserId).append("' id from basic='");
                sb.append(basicUserId).append("'");
                throw new LoginException(sb.toString());
            }
            authnInfo.id = certUserId;
            authnInfo.providedBasic = true;
            authnInfo.providedCert = true;
        } else if (certUserId != null) {
            authnInfo.providedCert = true;
            authnInfo.id = certUserId;
        } else if (basicUserId != null) {
            authnInfo.providedBasic = true;
            authnInfo.id = basicUserId;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(authnInfo + " from CERT:'" + certUserId + "' BASIC:'" + basicUserId + "'"));
        }
        return authnInfo;
    }

    public static class AuthnInfo {
        private String id;
        private boolean providedBasic;
        private boolean providedCert;

        public String getId() {
            return this.id;
        }

        public boolean isProvidedBasic() {
            return this.providedBasic;
        }

        public boolean isProvidedCert() {
            return this.providedCert;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("AuthnInfo: ID='").append(this.id);
            sb.append("' cert:").append(this.providedCert).append(" basic:").append(this.providedBasic);
            return sb.toString();
        }
    }
}

