/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.auth;

import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class AuthorizationHeaderSupport {
    public static String getAuthTokenValue(HttpServletRequest req, String schemeName) {
        Enumeration e = req.getHeaders("Authorization");
        while (e.hasMoreElements()) {
            String authzHeaderValue = (String)e.nextElement();
            String[] splitOnSpace = authzHeaderValue.split(" ");
            String scheme = splitOnSpace[0];
            if (!StringUtils.equalsIgnoreCase((String)schemeName, (String)scheme)) continue;
            return splitOnSpace.length == 2 ? splitOnSpace[1] : "";
        }
        return null;
    }

    public static boolean isSchemeUsed(HttpServletRequest req, String schemeName) {
        Enumeration e = req.getHeaders("Authorization");
        while (e.hasMoreElements()) {
            String authzHeaderValue = (String)e.nextElement();
            String[] splitOnSpace = authzHeaderValue.split(" ");
            String scheme = splitOnSpace[0];
            if (!StringUtils.equalsIgnoreCase((String)schemeName, (String)scheme)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAuthorizationHeaderValid(HttpServletRequest req) {
        Enumeration e = req.getHeaders("Authorization");
        return Collections.list(e).size() <= 1;
    }
}

