/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.auth;

import com.pingidentity.common.security.InputValidator;
import com.pingidentity.common.security.InvalidInputException;
import com.pingidentity.common.security.UsernameRule;
import com.pingidentity.common.util.B64;
import java.io.IOException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.auth.AuthorizationHeaderSupport;
import org.sourceid.auth.BasicAuthValue;
import org.sourceid.common.Util;

public class BasicAuthHelp {
    protected static final Log log = LogFactory.getLog(BasicAuthHelp.class);
    public static final String BASIC_SCHEME = "Basic";

    public static String getHeaderValue(HttpServletRequest req) {
        return BasicAuthHelp.getAuthTokenFromHeaders(req);
    }

    public static String getAuthTokenFromHeaders(HttpServletRequest req) {
        return AuthorizationHeaderSupport.getAuthTokenValue(req, BASIC_SCHEME);
    }

    public static BasicAuthValue getValues(String authToken) throws LoginException {
        return BasicAuthHelp.getValues(authToken, false);
    }

    public static BasicAuthValue getValues(String authToken, boolean allowEmptyPassword) throws LoginException {
        return BasicAuthHelp.getValues(authToken, allowEmptyPassword, false);
    }

    public static BasicAuthValue getValues(String authToken, boolean allowEmptyPassword, boolean urlDecodeValue) throws LoginException {
        String password = "";
        if (StringUtils.isBlank((String)authToken)) {
            throw new LoginException("No credentials provided with BasicAuthorization");
        }
        String work = B64.decodeToString((String)authToken);
        int colonIndex = work.indexOf(58);
        colonIndex = colonIndex < 0 ? work.length() : colonIndex;
        String username = work.substring(0, colonIndex);
        try {
            InputValidator.validate("Authorization", username, new UsernameRule());
        }
        catch (InvalidInputException e) {
            throw new LoginException("HTTP Basic  username has invalid content " + e);
        }
        String string = password = colonIndex == work.length() ? password : work.substring(colonIndex + 1);
        if (StringUtils.isEmpty((String)password) && !allowEmptyPassword) {
            throw new LoginException("Password must be provided");
        }
        if (username.length() == 0) {
            throw new LoginException("Username must be provided");
        }
        if (urlDecodeValue) {
            username = Util.urlDecodeUTF8(username);
            if (StringUtils.isNotEmpty((String)password)) {
                password = Util.urlDecodeUTF8(password);
            }
        }
        return new BasicAuthValue(username, password);
    }

    public static void sendChallenge(HttpServletResponse resp) throws IOException {
        resp.setHeader("WWW-Authenticate", "Basic realm=\"PingFederate\"");
        resp.sendError(401, "HTTP Basic Authentication Required");
    }

    public static void sendChallenge(HttpServletResponse resp, String message) throws IOException {
        resp.setHeader("WWW-Authenticate", "Basic realm=\"PingFederate\"");
        resp.sendError(401, message);
    }
}

