/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.auth;

import com.pingidentity.crypto.X509CertPathValidatorSupport;
import java.security.cert.X509Certificate;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.config.SoapAuthStore;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;

public class CertAuth {
    public static final String CERT_REQ_ATTR_NAME = "javax.servlet.request.X509Certificate";
    private final Log log = LogFactory.getLog(this.getClass());
    private final SoapAuthStore soapAuthStore;
    private final TrustedCAsManager trustedCAsManager;

    public CertAuth(SoapAuthStore soapAuthStore) {
        this.soapAuthStore = soapAuthStore;
        this.trustedCAsManager = MgmtFactory.getTrustedCAsManager();
    }

    public CertAuth(SoapAuthStore soapAuthStore, TrustedCAsManager trustedCAsManager) {
        this.soapAuthStore = soapAuthStore;
        this.trustedCAsManager = trustedCAsManager;
    }

    public String doCertAuth(HttpServletRequest req, HttpServletResponse resp) throws LoginException {
        X509Certificate[] certs = (X509Certificate[])req.getAttribute(CERT_REQ_ATTR_NAME);
        if (certs != null && certs.length > 0) {
            return this.doCertAuthn(certs);
        }
        return null;
    }

    String doCertAuthn(X509Certificate[] chain) throws LoginException {
        String name = chain[0].getSubjectDN().getName();
        SoapAuthInfo incoming = this.soapAuthStore.getByIncomingCert(name);
        String providerID = null;
        if (incoming != null && incoming.isHasCertEntry()) {
            SoapAuthInfo.CertAuthInfo certInfo = incoming.getCertAuthInfo();
            X509Certificate configuredCert = certInfo.getCert();
            if (configuredCert == null) {
                String configuredSubjectDN = certInfo.getSubjectDN();
                if (certInfo.getIssuerDN() != null) {
                    X509CertPathValidatorSupport validator = new X509CertPathValidatorSupport(chain, false);
                    validator.addTrustAnchors(this.trustedCAsManager.getTrustAnchorsByDN(new X500Principal(certInfo.getIssuerDN())));
                    validator.pruneCertChain();
                    if (validator.isPathValid()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Subject DN and Issuer DN cert authn for " + name + " | " + configuredSubjectDN + " | " + certInfo.getIssuerDN()));
                        }
                        providerID = incoming.getEntityId();
                    }
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Subject DN only cert authn for " + name + " | " + configuredSubjectDN));
                    }
                    providerID = incoming.getEntityId();
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("CertAuth equality cert authn for " + chain[0]));
                }
                if (configuredCert.equals(chain[0])) {
                    providerID = incoming.getEntityId();
                } else {
                    this.log.warn((Object)("Bad cert credential for " + name));
                }
            }
        } else if (incoming == null) {
            this.log.warn((Object)("Cert auth is not configured for " + name));
        } else {
            this.log.warn((Object)("Wrong credential for " + name));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Do Cert Authn " + name + " -> " + providerID));
        }
        if (providerID == null && incoming != null) {
            throw new LoginException("Cert auth failed for " + name);
        }
        return providerID;
    }
}

