/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.auth.radius;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sourceid.auth.radius.FreeRadiusDictionary;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.attribute.VendorSpecificAttribute;
import org.tinyradius.dictionary.Dictionary;
import org.tinyradius.packet.RadiusPacket;

public class RadiusResponse {
    private final RadiusPacket packet;
    private final Map<String, List<String>> attributes = new HashMap<String, List<String>>();

    public RadiusResponse(RadiusPacket packet) {
        this.packet = packet;
        packet.setDictionary((Dictionary)FreeRadiusDictionary.getInstance());
        this.parseAttributes();
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public List<String> getAttributesByCode(int attributeTypeCode) {
        if (attributeTypeCode <= 0) {
            throw new IllegalArgumentException("Invalid RADIUS attribute type code: " + attributeTypeCode);
        }
        ArrayList<String> attributes = new ArrayList<String>();
        List radiusAttributes = this.packet.getAttributes(attributeTypeCode);
        for (RadiusAttribute radiusAttribute : radiusAttributes) {
            attributes.add(radiusAttribute.getAttributeValue());
        }
        return attributes;
    }

    private void parseAttributes() {
        List attributes = this.packet.getAttributes();
        for (RadiusAttribute attribute : attributes) {
            if (attribute instanceof VendorSpecificAttribute) {
                VendorSpecificAttribute vsa = (VendorSpecificAttribute)attribute;
                this.addVendorSpecificAttributes(vsa.getSubAttributes());
                continue;
            }
            this.addAttribute(attribute);
        }
    }

    private void addAttribute(RadiusAttribute attribute) {
        String attributeName = this.getAttributeName(attribute);
        String attributeValue = attribute.getAttributeValue();
        if (!this.attributes.containsKey(attributeName)) {
            ArrayList<String> attributeValues = new ArrayList<String>();
            attributeValues.add(attributeValue);
            this.attributes.put(attributeName, attributeValues);
        } else {
            this.attributes.get(attributeName).add(attributeValue);
        }
    }

    private void addVendorSpecificAttributes(List<RadiusAttribute> attributes) {
        for (RadiusAttribute attribute : attributes) {
            this.addVendorSpecificAttribute(attribute);
        }
    }

    private void addVendorSpecificAttribute(RadiusAttribute attribute) {
        String attributeName = this.getAttributeName(attribute);
        String attributeValue = attribute.getAttributeValue();
        if (this.attributes.containsKey(attributeName)) {
            this.attributes.get(attributeName).add(attributeValue);
        } else {
            ArrayList<String> attributeValues = new ArrayList<String>();
            attributeValues.add(attributeValue);
            this.attributes.put(attributeName, attributeValues);
        }
    }

    private String getAttributeName(RadiusAttribute attribute) {
        String attributeName = attribute.getAttributeTypeObject() != null ? attribute.getAttributeTypeObject().getName() : String.valueOf(attribute.getAttributeType());
        return attributeName;
    }
}

